/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.lang.Strings$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.View;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.PaperSubmission;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.SmsService;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class PaperAction
extends AdvisorSupport {
    private Option smsService = None$.MODULE$;

    public Option<SmsService> smsService() {
        return this.smsService;
    }

    public void smsService_$eq(Option<SmsService> x$1) {
        this.smsService = x$1;
    }

    public View index() {
        Iterable<Writer> writers = this.getWriters();
        Map papers = ((IterableOnceOps)this.entityDao().findBy(ThesisPaper.class, "writer", writers).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)x.writer(), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("papers", papers);
        this.put("submissions", this.entityDao().findBy(PaperSubmission.class, "writer", writers).groupBy((Function1 & Serializable)_$1 -> _$1.writer()));
        this.put("writers", writers);
        return this.forward(this.forward$default$1());
    }

    public View auditForm() {
        Advisor advisor = this.getAdvisor();
        ThesisPaper paper = (ThesisPaper)this.entityDao().get(ThesisPaper.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("paper")));
        if (paper.writer().advisor().contains((Object)advisor)) {
            Seq submissions = this.entityDao().findBy(PaperSubmission.class, "writer", (Object)paper.writer());
            this.put("paper", paper);
            this.put("submissions", submissions);
            return this.forward(this.forward$default$1());
        }
        return this.redirect("index", "\u53ea\u80fd\u5ba1\u6838\u81ea\u5df1\u5b66\u751f\u7684\u8bba\u6587");
    }

    public View audit() {
        Advisor advisor = this.getAdvisor();
        ThesisPaper paper = (ThesisPaper)this.entityDao().get(ThesisPaper.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("paper")));
        if (paper.writer().advisor().contains((Object)advisor)) {
            Writer writer = paper.writer();
            Option advisorPassed = this.getBoolean("passed");
            Option advisorOpinion = this.get("opinion");
            if (paper.finalized()) {
                paper.advisorPassed_$eq(advisorPassed);
            }
            this.entityDao().saveOrUpdate((Object)paper, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
            this.getLong("submission.id").foreach((Function1)(JFunction1.mcVJ.sp & Serializable)subId -> {
                Iterable parts;
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)subId));
                PaperSubmission sub = (PaperSubmission)this.entityDao().findBy(PaperSubmission.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).head();
                sub.advisorOpinion_$eq(advisorOpinion);
                if (sub.finalized()) {
                    sub.advisorPassed_$eq(advisorPassed);
                }
                if ((parts = this.getAll("file", Part.class, ClassTag$.MODULE$.apply(Part.class))).nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
                    Part part = (Part)parts.head();
                    Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
                    String submissionFileName = System.currentTimeMillis() + "." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
                    BlobMeta meta1 = blob.upload("/" + writer.season().id().toString() + ("/advisor_revision/" + advisor.id() + "/"), part.getInputStream(), submissionFileName, advisor.code() + " " + advisor.name());
                    sub.revisionPath_$eq((Option)Some$.MODULE$.apply((Object)meta1.filePath()));
                } else if (sub.revisionPath().nonEmpty()) {
                    Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
                    blob.remove((String)sub.revisionPath().get());
                    sub.revisionPath_$eq((Option)None$.MODULE$);
                }
                this.entityDao().saveOrUpdate((Object)sub, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PaperSubmission[0]));
            });
            if (advisorPassed.isEmpty()) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"paper.id");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, paper.id());
                this.businessLogger().info("\u6307\u5bfc\u4e86" + paper.writer().code() + " " + paper.writer().name() + "\u7684\u8bba\u6587", writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            } else {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"paper.id");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, paper.id());
                this.businessLogger().info("\u5ba1\u6838\u4e86" + paper.writer().code() + " " + paper.writer().name() + "\u7684\u8bba\u6587\uff0c\u7ed3\u8bba\u4e3a\uff1a" + advisorPassed.get(), writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            if (writer.mobile().nonEmpty() && ((String)writer.mobile().get()).length() == 11) {
                this.smsService().foreach((Function1 & Serializable)sms -> {
                    String template = paper.advisorPassed().isEmpty() ? writer.name() + "\u540c\u5b66\uff0c" + advisor.name() + "\u8001\u5e08\u7ed9\u60a8\u7684\u8bba\u6587\u586b\u5199\u4e86\u6307\u5bfc\u610f\u89c1\uff0c\u8bf7\u77e5\u6089\u3002" : writer.name() + "\u540c\u5b66\uff0c" + advisor.name() + "\u8001\u5e08\u5ba1\u6838\u4e86\u60a8\u7684\u8bba\u6587\uff0c\u7ed3\u8bba\u4e3a\uff1a" + (BoxesRunTime.unboxToBoolean((Object)paper.advisorPassed().get()) ? "\u901a\u8fc7" : "\u4e0d\u901a\u8fc7\uff0c\u4fee\u6539\u540e\u63d0\u4ea4") + "\uff0c\u8bf7\u77e5\u6089\u3002";
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc(writer.mobile().get());
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer.name());
                    return sms.send(template, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                });
            }
            return this.redirect("index", "\u5ba1\u6838\u6210\u529f");
        }
        return this.redirect("index", "\u53ea\u80fd\u5ba1\u6838\u81ea\u5df1\u5b66\u751f\u7684\u8bba\u6587");
    }

    public View submission() {
        Seq subs = this.entityDao().findBy(PaperSubmission.class, "writer.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        this.put("subs", subs);
        return this.forward(this.forward$default$1());
    }

    public View submissionDoc() {
        Option sub = this.entityDao().find(PaperSubmission.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("submission")));
        Option option = sub;
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            PaperSubmission s = (PaperSubmission)((Some)option).value();
            return this.download(s.filePath());
        }
        throw new MatchError((Object)option);
    }

    public View doc() {
        Option paper;
        Option option;
        Option option2 = this.getLong("id");
        if (None$.MODULE$.equals(option2)) {
            option = this.entityDao().findBy(ThesisPaper.class, "writer.id", (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer"))).headOption();
        } else if (option2 instanceof Some) {
            long id = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
            option = Some$.MODULE$.apply((Object)this.entityDao().get(ThesisPaper.class, (Object)BoxesRunTime.boxToLong((long)id)));
        } else {
            throw new MatchError((Object)option2);
        }
        Option option3 = paper = option;
        if (None$.MODULE$.equals(option3)) {
            return Status$.MODULE$.NotFound();
        }
        if (option3 instanceof Some) {
            ThesisPaper file = (ThesisPaper)((Some)option3).value();
            return this.download(file.filePath());
        }
        throw new MatchError((Object)option3);
    }

    private View download(String filePath) {
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(filePath);
        HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
        response2.sendRedirect(((URL)path.get()).toString());
        return null;
    }
}

