/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.std;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.MidtermCheck;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.action.std.WriterSupport;
import org.openurp.degree.thesis.web.helper.StageChecker;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class MidtermCheckAction
extends WriterSupport {
    public View index() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option midtermCheck = this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writer).headOption();
        Deadline deadline = writer.getOrCreateDeadline(Stage$.MidtermCheck);
        StageTime stageTime = plan.getStageTime(Stage$.MidtermCheck);
        Object message = "";
        Option option = deadline.endAt();
        if (None$.MODULE$.equals(option)) {
            message = "\u8bf7\u4e8e " + stageTime.endOn() + "\u524d\u5b8c\u6210\u64b0\u5199\u5e76\u63d0\u4ea4";
        } else if (option instanceof Some) {
            Instant endAt = (Instant)((Some)option).value();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            message = "\u8bf7\u4e8e " + endAt.atZone(ZoneId.systemDefault()).format(formatter) + "\u524d\u5b8c\u6210\u63d0\u4ea4";
        } else {
            throw new MatchError((Object)option);
        }
        this.put("message", message);
        if (deadline.delayCount() > 0) {
            this.put("delay", "\u4f60\u7684\u4e2d\u671f\u68c0\u67e5\u62a5\u544a\u5df2\u5ef6\u671f " + deadline.delayCount() + "\u6b21 ,\u591a\u6b21\u5ef6\u671f\u5c06\u5f71\u54cd\u5230\u8bba\u6587\u6700\u7ec8\u6210\u7ee9");
        }
        this.put("writer", writer);
        this.put("midtermCheck", midtermCheck);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option<String> option = new StageChecker(this.entityDao(), plan).check(writer, Stage$.MidtermCheck, true);
        if (option instanceof Some) {
            String msg = (String)((Some)option).value();
            return this.redirect("index", msg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        MidtermCheck midtermCheck = (MidtermCheck)this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writer).headOption().getOrElse(MidtermCheckAction::$anonfun$1);
        this.put("writer", writer);
        this.put("midtermCheck", midtermCheck);
        return this.forward(this.forward$default$1());
    }

    public View info() {
        Writer writer = this.getWriter();
        this.put("writer", writer);
        OqlBuilder cQuery = OqlBuilder$.MODULE$.from(MidtermCheck.class, "c");
        cQuery.where("c.writer=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}));
        this.put("midtermCheck", this.entityDao().search((QueryBuilder)cQuery).headOption());
        return this.forward(this.forward$default$1());
    }

    public View save() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option<String> option = new StageChecker(this.entityDao(), plan).check(writer, Stage$.MidtermCheck, true);
        if (option instanceof Some) {
            String msg = (String)((Some)option).value();
            return this.redirect("index", msg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        MidtermCheck k = (MidtermCheck)this.entityDao().findBy(MidtermCheck.class, "writer", (Object)writer).headOption().getOrElse(MidtermCheckAction::$anonfun$2);
        k.proceeding_$eq((String)this.get("proceeding", ""));
        k.submitAt_$eq(Instant.now());
        k.writer_$eq(writer);
        k.status_$eq(AuditStatus$.Submited);
        this.entityDao().saveOrUpdate((Object)k, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MidtermCheck[0]));
        return this.redirect("index", "info.save.success");
    }

    private static final MidtermCheck $anonfun$1() {
        return new MidtermCheck();
    }

    private static final MidtermCheck $anonfun$2() {
        return new MidtermCheck();
    }
}

