/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.std;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.beangle.data.model.LongId;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.degree.thesis.model.Deadline;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Proposal;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.action.std.WriterSupport;
import org.openurp.degree.thesis.web.helper.StageChecker;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class ProposalAction
extends WriterSupport {
    public View index() {
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option proposal = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        Deadline deadline = writer.getOrCreateDeadline(Stage$.Proposal);
        Object message = "";
        StageTime stageTime = plan.getStageTime(Stage$.Proposal);
        Option option = deadline.endAt();
        if (None$.MODULE$.equals(option)) {
            message = "\u8bf7\u4e8e " + stageTime.endOn() + "\u524d\u5b8c\u6210\u64b0\u5199\u5e76\u63d0\u4ea4";
        } else if (option instanceof Some) {
            Instant endAt = (Instant)((Some)option).value();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            message = "\u8bf7\u4e8e " + endAt.atZone(ZoneId.systemDefault()).format(formatter) + "\u524d\u5b8c\u6210\u64b0\u5199\u5e76\u63d0\u4ea4";
        } else {
            throw new MatchError((Object)option);
        }
        this.put("message", message);
        if (deadline.delayCount() > 0) {
            this.put("delay", "\u4f60\u7684\u5f00\u9898\u62a5\u544a\u5df2\u5ef6\u671f " + deadline.delayCount() + "\u6b21 ,\u591a\u6b21\u5ef6\u671f\u5c06\u5f71\u54cd\u5230\u8bba\u6587\u6700\u7ec8\u6210\u7ee9");
        }
        this.put("writer", writer);
        this.put("proposal", proposal);
        return this.forward(this.forward$default$1());
    }

    public View edit() {
        Proposal proposal;
        Writer writer = this.getWriter();
        DepartPlan plan = (DepartPlan)this.thesisPlanService().getDepartPlan(writer).get();
        Option<String> option = new StageChecker(this.entityDao(), plan).check(writer, Stage$.Proposal, false);
        if (option instanceof Some) {
            String msg = (String)((Some)option).value();
            return this.redirect("index", msg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        Option option2 = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        if (option2 instanceof Some) {
            Proposal p;
            proposal = p = (Proposal)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            Proposal p = new Proposal();
            p.writer_$eq(writer);
            proposal = p;
        } else {
            throw new MatchError((Object)option2);
        }
        Proposal proposal2 = proposal;
        this.put("writer", writer);
        this.put("proposal", proposal2);
        return this.forward(this.forward$default$1());
    }

    public View info() {
        Writer writer = this.getWriter();
        Option proposal = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        this.put("writer", writer);
        this.put("proposal", proposal);
        return this.forward(this.forward$default$1());
    }

    public View submit() {
        Writer writer = this.getWriter();
        Option proposalOption = this.entityDao().findBy(Proposal.class, "writer", (Object)writer).headOption();
        Proposal proposal = (Proposal)proposalOption.getOrElse(ProposalAction::$anonfun$1);
        proposal.writer_$eq(writer);
        proposal.submitAt_$eq(Instant.now());
        proposal.meanings_$eq((String)this.get("proposal.meanings", ""));
        proposal.conditions_$eq((String)this.get("proposal.conditions", ""));
        proposal.outline_$eq((String)this.get("proposal.outline", ""));
        proposal.references_$eq((String)this.get("proposal.references", ""));
        proposal.methods_$eq((String)this.get("proposal.methods", ""));
        boolean justSave = this.getBoolean("justSave", true);
        if (!justSave) {
            proposal.status_$eq(AuditStatus$.Submited);
            Deadline deadline = writer.getOrCreateDeadline(Stage$.Proposal);
            deadline.submitAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
            this.entityDao().saveOrUpdate((Object)proposal, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{deadline}));
        } else {
            proposal.status_$eq(AuditStatus$.Draft);
            this.entityDao().saveOrUpdate((Object)proposal, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Proposal[0]));
        }
        return this.redirect("index", "info.save.success");
    }

    private static final Proposal $anonfun$1() {
        return new Proposal();
    }
}

