/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.helper;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.importer.ImportListener;
import org.beangle.doc.transfer.importer.ImportResult;
import org.beangle.doc.transfer.importer.Importer;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.ThesisCheck;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.ThesisCheckService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ThesisCheckImportListener
implements ImportListener {
    private Importer transfer;
    private final GraduateSeason season;
    private final EntityDao entityDao;
    private final ThesisCheckService thesisCheckService;

    public ThesisCheckImportListener(GraduateSeason season, EntityDao entityDao, ThesisCheckService thesisCheckService) {
        this.season = season;
        this.entityDao = entityDao;
        this.thesisCheckService = thesisCheckService;
        ImportListener.$init$((ImportListener)this);
    }

    public Importer transfer() {
        return this.transfer;
    }

    public void transfer_$eq(Importer x$1) {
        this.transfer = x$1;
    }

    public void onItemStart(ImportResult tr) {
        this.transfer().curData().get((Object)"writer.std.code").foreach((Function1)(JProcedure1 & Serializable)code -> {
            Option<Writer> option = this.thesisCheckService.findWriter(code.toString());
            if (None$.MODULE$.equals(option)) {
                tr.addFailure("\u627e\u4e0d\u5230\u5b66\u751f\u7684\u6bd5\u4e1a\u8bba\u6587\u4fe1\u606f", code);
                return;
            }
            if (option instanceof Some) {
                ThesisCheck thesisCheck;
                Writer w = (Writer)((Some)option).value();
                OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisCheck.class, "c");
                query.where("c.writer=:writer and c.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{w, this.season}));
                query.where("c.degreeMajorCode=:degreeMajorCode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.transfer().curData().get((Object)"thesisCheck.degreeMajorCode").get().toString()}));
                Option option2 = this.entityDao.search((QueryBuilder)query).headOption();
                if (None$.MODULE$.equals(option2)) {
                    ThesisCheck c = new ThesisCheck();
                    c.writer_$eq(w);
                    c.season_$eq(this.season);
                    c.title_$eq("--");
                    c.updatedAt_$eq(Instant.now());
                    thesisCheck = c;
                } else if (option2 instanceof Some) {
                    ThesisCheck tp;
                    thesisCheck = tp = (ThesisCheck)((Some)option2).value();
                } else {
                    throw new MatchError((Object)option2);
                }
                ThesisCheck check = thesisCheck;
                this.transfer().current_$eq((Object)check);
                return;
            }
            throw new MatchError(option);
        });
    }

    public void onItemFinish(ImportResult tr) {
        ThesisCheck c = (ThesisCheck)this.transfer().current();
        if (c.departNo().isEmpty()) {
            tr.addFailure("\u540d\u5355\u4e0d\u5b58\u5728,\u9700\u8981\u4e8b\u5148\u5bfc\u5165", this.transfer().curData().getOrElse((Object)"writer.std.code", ThesisCheckImportListener::onItemFinish$$anonfun$1));
            return;
        }
        if (c.writer().persisted()) {
            this.entityDao.saveOrUpdate((Object)c, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisCheck[0]));
            this.thesisCheckService.updateDoc(c);
            Option paper = this.entityDao.findBy(ThesisPaper.class, "writer", (Object)c.writer()).headOption();
            String string = c.title();
            String string2 = "--";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                paper.foreach((Function1)(JProcedure1 & Serializable)pd -> {
                    c.title_$eq(pd.title());
                    c.language_$eq(pd.language());
                    c.keywords_$eq(pd.keywords());
                    c.researchField_$eq(pd.researchField());
                    c.advisor_$eq((Option)Some$.MODULE$.apply(c.writer().advisor().map((Function1 & Serializable)_$1 -> _$1.name()).getOrElse(ThesisCheckImportListener::onItemFinish$$anonfun$2$$anonfun$2)));
                    this.entityDao.saveOrUpdate((Object)c, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisCheck[0]));
                });
                return;
            }
            paper.foreach((Function1)(JProcedure1 & Serializable)pd -> {
                String string = c.title();
                String string2 = "--";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    c.writer().thesisTitle_$eq((Option)Some$.MODULE$.apply((Object)c.title()));
                    c.writer().researchField_$eq(c.researchField());
                    pd.title_$eq(c.title());
                }
                if (c.language().nonEmpty()) {
                    pd.language_$eq(c.language());
                }
                if (c.keywords().nonEmpty()) {
                    pd.keywords_$eq(c.keywords());
                }
                if (c.researchField().nonEmpty()) {
                    pd.researchField_$eq(c.researchField());
                }
                this.entityDao.saveOrUpdate(pd, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
            });
            return;
        }
    }

    private static final Object onItemFinish$$anonfun$1() {
        return "--";
    }

    private static final String onItemFinish$$anonfun$2$$anonfun$2() {
        return "--";
    }
}

