/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.admin;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.zip.Zipper$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.LongId;
import org.beangle.ems.app.EmsApp$;
import org.beangle.ems.app.blob.BlobMeta;
import org.beangle.ems.app.blob.Repository;
import org.beangle.ems.app.web.WebBusinessLogger;
import org.beangle.webmvc.To;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.code.service.CodeService;
import org.openurp.degree.thesis.model.CopyCheck;
import org.openurp.degree.thesis.model.Stage;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.ThesisCheck;
import org.openurp.degree.thesis.model.ThesisDoc;
import org.openurp.degree.thesis.model.ThesisPaper;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.DeferService;
import org.openurp.degree.thesis.service.doc.ThesisDocGenerator$;
import org.openurp.degree.thesis.web.action.admin.WriterAction;
import org.openurp.degree.thesis.web.helper.PaperDownloadHelper$;
import org.openurp.starter.web.support.ProjectSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Exception performing whole class analysis ignored.
 */
public class PaperAction
extends RestfulAction<ThesisPaper>
implements ProjectSupport,
ExportSupport<ThesisPaper> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private final Map stageDirNames;
    private DeferService deferService;
    private WebBusinessLogger businessLogger;

    public PaperAction() {
        ProjectSupport.$init$((ProjectSupport)this);
        Object[] objectArray = new Tuple2[2];
        Stage stage = (Stage)Predef$.MODULE$.ArrowAssoc((Object)Stage$.Proposal);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stage, (Object)"proposal");
        Stage stage2 = (Stage)Predef$.MODULE$.ArrowAssoc((Object)Stage$.OralDefense);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stage2, (Object)"oralDefense");
        this.stageDirNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public Map<Stage, String> stageDirNames() {
        return this.stageDirNames;
    }

    public DeferService deferService() {
        return this.deferService;
    }

    public void deferService_$eq(DeferService x$1) {
        this.deferService = x$1;
    }

    public WebBusinessLogger businessLogger() {
        return this.businessLogger;
    }

    public void businessLogger_$eq(WebBusinessLogger x$1) {
        this.businessLogger = x$1;
    }

    public View index() {
        LazyRef lazyRef = new LazyRef();
        this.put("departs", (Object)this.getDeparts(this.project$1(lazyRef)));
        OqlBuilder gQuery = OqlBuilder$.MODULE$.from(GraduateSeason.class, "gg");
        gQuery.orderBy("gg.graduateIn desc");
        this.put("seasons", (Object)this.entityDao().search((QueryBuilder)gQuery));
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<ThesisPaper> getQueryBuilder() {
        LazyRef lazyRef = new LazyRef();
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        QueryHelper$.MODULE$.dateBetween(query, null, "submitAt", "uploadBeginOn", "uploadEndOn");
        this.getBoolean("needRecheck").foreach((Function1 & Serializable)needRecheck -> PaperAction.getQueryBuilder$$anonfun$1((OqlBuilder)query, (boolean)BoxesRunTime.unboxToBoolean((Object)needRecheck)));
        query.where("thesisPaper.writer.std.state.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$2(lazyRef))}));
        return query;
    }

    public View missing() {
        long seasonId = BoxesRunTime.unboxToLong((Object)this.getLong("thesisPaper.writer.season.id").get());
        String departId = "";
        Option option = this.getInt("thesisPaper.writer.std.state.department.id");
        if (option instanceof Some) {
            int id = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            departId = BoxesRunTime.boxToInteger((int)id).toString();
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        return this.redirect((To)this.to(WriterAction.class, "absence", "&absence=paper&orderBy=writer.std.code&writer.season.id=" + seasonId + "&writer.std.state.department.id=" + departId), null);
    }

    public View search() {
        Seq papers = this.entityDao().search((QueryBuilder)this.getQueryBuilder());
        this.put("thesisPapers", (Object)papers);
        return this.forward(this.forward$default$1());
    }

    public View updateAdvisorPassed() {
        Seq papers = this.entityDao().find(ThesisPaper.class, (Iterable)this.getLongIds("thesisPaper"));
        boolean advisorPassed = this.getBoolean("passed", true);
        papers.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.advisorPassed_$eq((Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)advisorPassed))));
        this.entityDao().saveOrUpdate((Iterable)papers);
        return this.redirect("search", "\u8bbe\u7f6e\u6210\u529f");
    }

    public View cover() {
        Seq papers = this.entityDao().find(ThesisPaper.class, (Iterable)this.getLongIds("thesisPaper"));
        GraduateSeason season = ((ThesisPaper)papers.head()).writer().season();
        Department depart = ((ThesisPaper)papers.head()).writer().department();
        String dir = ThesisDocGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "cover");
        papers.foreach((Function1)(JProcedure1 & Serializable)paper -> {
            Writer writer = paper.writer();
            InputStream is = ThesisDocGenerator$.MODULE$.genCover(writer);
            FileOutputStream file = new FileOutputStream(new File(dir + Files$.MODULE$.$div() + (writer.std().code() + "\u8bba\u6587\u5c01\u9762.docx")));
            IOs$.MODULE$.copy(is, (OutputStream)file);
            IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{file}));
        });
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "cover");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = season.name() + "_" + depart.name() + " \u5c01\u9762.zip";
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View doc() {
        Seq papers = this.entityDao().find(ThesisPaper.class, (Iterable)this.getLongIds("thesisPaper"));
        if (papers.size() == 1) {
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(((ThesisPaper)papers.head()).filePath());
            HttpServletResponse response2 = ActionContext$.MODULE$.current().response();
            response2.sendRedirect(((URL)path.get()).toString());
            return null;
        }
        GraduateSeason season = ((ThesisPaper)papers.head()).writer().season();
        Department depart = ((ThesisPaper)papers.head()).writer().department();
        File dir = new File(ThesisDocGenerator$.MODULE$.getDepartFolder(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp"));
        PaperDownloadHelper$.MODULE$.download(dir, (Iterable)papers);
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(BoxesRunTime.unboxToLong((Object)season.id()), BoxesRunTime.unboxToInt((Object)depart.id()), "tmp");
        Zipper$.MODULE$.zip(dir, targetZip, Zipper$.MODULE$.zip$default$3());
        String fileName = season.name() + "_" + ((ThesisPaper)papers.head()).writer().code() + ("\u7b49" + papers.size() + "\u7bc7\u8bba\u6587.zip");
        return Stream$.MODULE$.apply(targetZip, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    public View stat() {
        LazyRef lazyRef = new LazyRef();
        long seasonId = BoxesRunTime.unboxToLong((Object)this.getLong("thesisPaper.writer.season.id").get());
        OqlBuilder query = OqlBuilder$.MODULE$.from(Writer.class.getName(), "writer");
        query.where("writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query.where("writer.std.state.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$3(lazyRef))}));
        query.select("writer.std.state.department.id,writer.std.state.department.code,writer.std.state.department.name,count(*)");
        query.groupBy("writer.std.state.department.id,writer.std.state.department.code,writer.std.state.department.name");
        query.orderBy("writer.std.state.department.code");
        Seq writers = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(ThesisPaper.class.getName(), "paper");
        query2.where("paper.writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("paper.writer.std.state.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts(this.project$3(lazyRef))}));
        query2.where("paper.finalized=true and paper.advisorPassed=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        query2.select("paper.writer.std.state.department.id,count(*)");
        query2.groupBy("paper.writer.std.state.department.id,paper.writer.std.state.department.name");
        Map papers = ((IterableOnceOps)this.entityDao().search((QueryBuilder)query2).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x[0], x[1]))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map zipTimes = Collections$.MODULE$.newMap();
        papers.foreach((Function1)(JProcedure1 & Serializable)p -> {
            Tuple2 NonEmptyTuple_this = p;
            int departId = ((Number)NonEmptyTuple_this._1()).intValue();
            File f = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departId, "paper");
            if (f.exists()) {
                zipTimes.put((Object)BoxesRunTime.boxToInteger((int)departId), (Object)new Date(f.lastModified()));
                return;
            }
        });
        this.put("writers", (Object)writers);
        this.put("papers", (Object)papers);
        this.put("zipTimes", (Object)zipTimes);
        this.put("seasonId", (Object)BoxesRunTime.boxToLong((long)seasonId));
        return this.forward(this.forward$default$1());
    }

    public View genZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(ThesisPaper.class, "paper");
        query2.where("paper.writer.season.id=:seasonId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)seasonId)}));
        query2.where("paper.writer.std.state.department.id=:departId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)departmentId)}));
        query2.where("paper.finalized=true and paper.advisorPassed=true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Seq papers = this.entityDao().search((QueryBuilder)query2);
        String dir = ThesisDocGenerator$.MODULE$.getDepartFolder(seasonId, departmentId, "paper");
        PaperDownloadHelper$.MODULE$.download(new File(dir), (Iterable)papers);
        File targetZip = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "paper");
        Zipper$.MODULE$.zip(new File(dir), targetZip, Zipper$.MODULE$.zip$default$3());
        return this.redirect("stat", "thesisPaper.writer.season.id=" + seasonId, "\u751f\u6210\u6210\u529f");
    }

    public View downloadZip() {
        long seasonId = this.getLongId("season");
        int departmentId = this.getIntId("department");
        File file = ThesisDocGenerator$.MODULE$.getDepartZipFile(seasonId, departmentId, "paper");
        Department depart = (Department)this.entityDao().get(Department.class, (Object)BoxesRunTime.boxToInteger((int)departmentId));
        GraduateSeason season = (GraduateSeason)this.entityDao().get(GraduateSeason.class, (Object)BoxesRunTime.boxToLong((long)seasonId));
        String fileName = season.name() + "_" + depart.name() + " \u8bba\u6587.zip";
        return Stream$.MODULE$.apply(file, MediaTypes$.MODULE$.ApplicationZip(), fileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View uploadForm() {
        Writer writer;
        Option option = this.getLong("thesisPaper.id");
        if (None$.MODULE$.equals(option)) {
            Option option2 = this.getLong("writer.id");
            if (None$.MODULE$.equals(option2)) {
                writer = null;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                long writerId = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)writerId));
            }
        } else {
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            long paperId = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            ThesisPaper paper = (ThesisPaper)this.entityDao().get(ThesisPaper.class, (Object)BoxesRunTime.boxToLong((long)paperId));
            this.put("thesisPaper", (Object)paper);
            writer = paper.writer();
        }
        Writer writer2 = writer;
        if (writer2 == null) {
            return Status$.MODULE$.NotFound();
        }
        this.put("writer", writer2);
        return this.forward(this.forward$default$1());
    }

    public View upload() {
        Writer writer = (Writer)this.entityDao().get(Writer.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("writer")));
        ThesisPaper paper = (ThesisPaper)this.entityDao().first((QueryBuilder)OqlBuilder$.MODULE$.from(ThesisPaper.class, "f").where("f.writer=:writer", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{writer}))).getOrElse(PaperAction::$anonfun$2);
        String title = (String)this.get("thesisPaper.title", (Object)"--");
        this.populate((Entity)paper, "thesisPaper");
        if (paper.persisted()) {
            paper.writer_$eq(writer);
        }
        paper.excellent_$eq(BoxesRunTime.unboxToBoolean((Object)this.getBoolean("thesisPaper.excellent").getOrElse(PaperAction::upload$$anonfun$1)));
        writer.thesisTitle_$eq((Option)Some$.MODULE$.apply((Object)title));
        Iterable parts = this.getAll("paper_file", Part.class, ClassTag$.MODULE$.apply(Part.class));
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            if (paper.filePath() != null && paper.filePath().startsWith("/")) {
                blob.remove(paper.filePath());
            }
            String fileName = part.getSubmittedFileName();
            String storeName = writer.std().code() + "." + Strings$.MODULE$.substringAfterLast(fileName, ".");
            BlobMeta meta = blob.upload("/" + writer.season().id().toString() + "/paper/", part.getInputStream(), storeName, writer.std().code() + " " + writer.std().name());
            paper.filePath_$eq(meta.filePath());
            paper.name_$eq(storeName);
            paper.submitAt_$eq(Instant.now());
            paper.status_$eq(AuditStatus$.Submited);
            paper.writer_$eq(writer);
            paper.title_$eq((String)writer.thesisTitle().getOrElse(PaperAction::upload$$anonfun$2));
            this.entityDao().saveOrUpdate((Object)paper, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisPaper[0]));
            String msg = "\u4e0a\u4f20\u4e86\u8bba\u6587" + fileName;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)fileName);
            this.businessLogger().info(msg, writer.id(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        this.entityDao().saveOrUpdate((Object)paper, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LongId[]{paper.writer()}));
        this.uploadSingleDoc(paper, "proposal_file", Stage$.Proposal);
        this.uploadSingleDoc(paper, "defense_file", Stage$.OralDefense);
        Seq checks = this.entityDao().findBy(ThesisCheck.class, "writer", (Object)writer);
        if (checks.size() == 1) {
            checks.foreach((Function1)(JProcedure1 & Serializable)c -> {
                c.title_$eq(paper.title());
                if (paper.language().nonEmpty()) {
                    c.language_$eq(paper.language());
                }
                if (paper.keywords().nonEmpty()) {
                    c.keywords_$eq(paper.keywords());
                }
                if (paper.researchField().nonEmpty()) {
                    c.researchField_$eq(paper.researchField());
                    return;
                }
            });
            this.entityDao().saveOrUpdate((Iterable)checks);
        }
        return this.redirect("search", "info.save.success");
    }

    private void uploadSingleDoc(ThesisPaper paper, String partName, Stage stage) {
        Iterable parts = this.getAll(partName, Part.class, ClassTag$.MODULE$.apply(Part.class));
        Writer writer = paper.writer();
        if (parts.nonEmpty() && ((Part)parts.head()).getSize() > 0L) {
            Part part = (Part)parts.head();
            Repository blob = EmsApp$.MODULE$.getBlobRepository(true);
            String storeName = writer.std().code() + "." + Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), ".");
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"writer");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)writer);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stage");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)stage);
            ThesisDoc dd = (ThesisDoc)this.entityDao().findBy(ThesisDoc.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption().getOrElse(PaperAction::$anonfun$3);
            dd.writer_$eq(writer);
            dd.stage_$eq(stage);
            if (dd.filePath() != null && dd.filePath().startsWith("/")) {
                blob.remove(dd.filePath());
            }
            BlobMeta meta = blob.upload("/" + writer.season().id().toString() + ("/" + this.stageDirNames().apply((Object)stage) + "/"), part.getInputStream(), storeName, writer.std().code() + " " + writer.std().name());
            dd.fileExt_$eq(meta.mediaType());
            dd.filePath_$eq(meta.filePath());
            dd.updatedAt_$eq(Instant.now());
            this.entityDao().saveOrUpdate((Object)dd, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisDoc[0]));
            return;
        }
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder query$1, boolean needRecheck) {
        String a = needRecheck ? "not" : "";
        return (OqlBuilder)query$1.where(a + " exists(from " + CopyCheck.class.getName() + " c where c.writer=thesisPaper.writer and c.passed=true)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }

    private static final ThesisPaper $anonfun$2() {
        return new ThesisPaper();
    }

    private static final boolean upload$$anonfun$1() {
        return false;
    }

    private static final String upload$$anonfun$2() {
        return "--";
    }

    private static final ThesisDoc $anonfun$3() {
        return new ThesisDoc();
    }
}

