/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.web.action.advisor;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.beangle.webmvc.context.ActionContext$;
import org.beangle.webmvc.view.View;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.Department;
import org.openurp.degree.thesis.model.Advisor;
import org.openurp.degree.thesis.model.CopyCheck;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Stage$;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.web.action.advisor.AdvisorSupport;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CrossReviewAction
extends AdvisorSupport {
    public View index() {
        Advisor advisor = this.getAdvisor();
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisReview.class, "review");
        query.where("review.crossReviewer=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{advisor.teacher()}));
        query.where("review.writer.season=:season", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((ThesisPlan)this.thesisPlanService().getPlan().get()).season()}));
        Seq reviews = this.entityDao().search((QueryBuilder)query);
        this.put("reviews", (Object)reviews);
        if (reviews.isEmpty()) {
            this.put("checks", (Object)Predef$.MODULE$.Map().empty());
        } else {
            Map checks = this.entityDao().findBy(CopyCheck.class, "writer", reviews.map((Function1 & Serializable)_$1 -> _$1.writer())).groupBy((Function1 & Serializable)_$2 -> _$2.writer());
            this.put("checks", (Object)checks);
        }
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(TeachingOffice.class, "office");
        query2.where("office.director.staff.code=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        Seq offices = this.entityDao().search((QueryBuilder)query2);
        this.put("offices", (Object)offices);
        return this.forward(this.forward$default$1());
    }

    public View reviewSetting() {
        ThesisReview review = (ThesisReview)this.entityDao().get(ThesisReview.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisReview")));
        this.put("review", (Object)review);
        if (review.crossReviewScore().isEmpty()) {
            return this.forward(this.forward$default$1());
        }
        ThesisPlan plan = (ThesisPlan)this.thesisPlanService().getPlan().get();
        Option dp = plan.departPlans().find((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = review.writer().department();
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        Option option = dp;
        if (None$.MODULE$.equals(option)) {
            return this.redirect("index", "\u4e0d\u5728\u8bc4\u5206\u65f6\u95f4");
        }
        if (option instanceof Some) {
            boolean intime;
            DepartPlan p = (DepartPlan)((Some)option).value();
            boolean bl = intime = p.getStageTime(Stage$.ThesisReview).timeSuitable(Instant.now()) == 0;
            if (intime) {
                return this.forward(this.forward$default$1());
            }
            return this.redirect("index", "\u4e0d\u5728\u8bc4\u5206\u65f6\u95f4");
        }
        throw new MatchError((Object)option);
    }

    public View review() {
        ThesisReview review = (ThesisReview)this.entityDao().get(ThesisReview.class, (Object)BoxesRunTime.boxToLong((long)this.getLongId("thesisReview")));
        review.crossReviewOpinion_$eq(this.get("thesisReview.crossReviewOpinion"));
        review.crossReviewScore_$eq(this.getFloat("thesisReview.crossReviewScore"));
        review.defensePermitted_$eq(this.getBoolean("thesisReview.defensePermitted"));
        review.crossReviewAt_$eq((Option)Some$.MODULE$.apply((Object)Instant.now()));
        this.entityDao().saveOrUpdate((Object)review, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ThesisReview[0]));
        Writer writer = review.writer();
        String msg = "\u4ea4\u53c9\u8bc4\u9605\u4e86" + writer.std().name() + "\u7684\u8bba\u6587\uff0c\u8bc4\u5206:" + review.crossReviewScore().getOrElse(CrossReviewAction::$anonfun$4);
        this.businessLogger().info(msg, writer.id(), (Object)ActionContext$.MODULE$.current().params());
        return this.redirect("index", "\u8bc4\u9605\u5b8c\u6210");
    }

    private static final Object $anonfun$4() {
        return BoxesRunTime.boxToInteger((int)0);
    }
}

