/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.impl;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.GraduateSeason;
import org.openurp.degree.thesis.model.DepartPlan;
import org.openurp.degree.thesis.model.Stage;
import org.openurp.degree.thesis.model.StageTime;
import org.openurp.degree.thesis.model.ThesisPlan;
import org.openurp.degree.thesis.model.Writer;
import org.openurp.degree.thesis.service.ThesisPlanService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class ThesisPlanServiceImpl
implements ThesisPlanService {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public Option<ThesisPlan> getPlan() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(ThesisPlan.class, "tp");
        query.where(":today between tp.beginOn and tp.endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        query.cacheable(query.cacheable$default$1());
        Seq intimePlans = this.entityDao().search((QueryBuilder)query);
        if (intimePlans.isEmpty()) {
            OqlBuilder query2 = OqlBuilder$.MODULE$.from(ThesisPlan.class, "tp");
            query2.orderBy("tp.beginOn desc");
            query2.cacheable(query2.cacheable$default$1());
            return this.entityDao().search((QueryBuilder)query2).headOption();
        }
        return intimePlans.headOption();
    }

    @Override
    public GraduateSeason getSeason() {
        return ((ThesisPlan)this.getPlan().get()).season();
    }

    @Override
    public boolean isOpen(ThesisPlan plan, Department depart, Stage stage) {
        Option option = plan.departPlans().find((Function1 & Serializable)x -> {
            Department department = x.department();
            Department department2 = depart;
            return !(department != null ? !department.equals(department2) : department2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            DepartPlan dp = (DepartPlan)((Some)option).value();
            Option option2 = dp.times().find((Function1 & Serializable)x -> {
                Stage stage = x.stage();
                Stage stage2 = stage;
                return !(stage != null ? !stage.equals(stage2) : stage2 != null);
            });
            if (None$.MODULE$.equals(option2)) {
                return false;
            }
            if (option2 instanceof Some) {
                StageTime st = (StageTime)((Some)option2).value();
                return st.timeSuitable(Instant.now()) == 0;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Seq<Department> getPlanDeparts(Seq<Department> ds) {
        Option<ThesisPlan> option = this.getPlan();
        if (option instanceof Some) {
            ThesisPlan p = (ThesisPlan)((Some)option).value();
            Buffer allDeparts = (Buffer)p.departPlans().map((Function1 & Serializable)_$2 -> _$2.department());
            return Collections$.MODULE$.intersection((Iterable)allDeparts, ds);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<DepartPlan> getDepartPlan(Writer writer) {
        Department depart = writer.department();
        GraduateSeason season = writer.season();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"department");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)depart);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"thesisPlan.season");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)season);
        return this.entityDao().findBy(DepartPlan.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).headOption();
    }
}

