/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.degree.thesis.service.doc;

import java.io.InputStream;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.ems.app.security.RemoteService$;
import org.openurp.degree.thesis.model.DefenseGroup;
import org.openurp.degree.thesis.model.ThesisReview;
import org.openurp.degree.thesis.model.Writer;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class DefenseReport$
implements Serializable {
    public static final DefenseReport$ MODULE$ = new DefenseReport$();

    private DefenseReport$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DefenseReport$.class);
    }

    public HSSFWorkbook render(DefenseGroup group, Map<Writer, ThesisReview> reviews) {
        HSSFWorkbook hsw = new HSSFWorkbook((InputStream)ClassLoaders$.MODULE$.getResourceAsStream("org/openurp/degree/thesis/template/defense_group.xls", ClassLoaders$.MODULE$.getResourceAsStream$default$2()).get());
        HSSFSheet sheet = hsw.getSheetAt(0);
        HSSFFont font = hsw.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)10);
        HSSFCellStyle style = hsw.createCellStyle();
        style.setFont(font);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        String schoolName = RemoteService$.MODULE$.getOrg().name();
        String title = schoolName + group.department().name() + "\u7b2c" + group.idx() + "\u7b54\u8fa9\u7ec4\u7b54\u8fa9\u8868";
        sheet.getRow(0).getCell(0).setCellValue(title);
        StringBuilder members = new StringBuilder("\u7b54\u8fa9\u7ec4\u957f\uff1a");
        group.members().foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (m.leader()) {
                members.append(m.teacher().name()).append(" ");
                return;
            }
        });
        members.append("\u7b54\u8fa9\u7ec4\u6210\u5458\uff1a");
        group.members().foreach((Function1)(JProcedure1 & Serializable)m -> {
            if (!m.leader()) {
                members.append(m.teacher().name()).append(" ");
                return;
            }
        });
        members.append("\u7b54\u8fa9\u65f6\u95f4: ");
        group.beginAt().foreach((Function1)(JProcedure1 & Serializable)beginAt -> {
            members.append(beginAt.atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("MM\u6708dd\u65e5HH:mm")));
            members.append("-");
            group.endAt().foreach((Function1 & Serializable)endAt -> members.append(endAt.atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("HH:mm"))));
        });
        members.append("\u5730\u70b9:" + group.place().getOrElse(DefenseReport$::render$$anonfun$4));
        sheet.getRow(2).getCell(0).setCellValue(members.toString());
        Buffer writers = group.orderedWriters();
        for (int i = 0; i < writers.size(); ++i) {
            Writer xs = (Writer)writers.apply(i);
            HSSFRow row = sheet.createRow(i + 5);
            HSSFCell[] cell = new HSSFCell[12];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 12).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                cell$1[j] = row.createCell(j);
                cell[j].setCellStyle(style);
            });
            cell[0].setCellValue(Int$.MODULE$.int2double(i + 1));
            cell[1].setCellValue(xs.name());
            cell[2].setCellValue(xs.code());
            cell[3].setCellValue((String)xs.squad().map((Function1 & Serializable)_$1 -> _$1.name()).getOrElse(DefenseReport$::render$$anonfun$7) + "\u73ed");
            cell[4].setCellValue((String)xs.advisor().map((Function1 & Serializable)_$2 -> _$2.name()).getOrElse(DefenseReport$::render$$anonfun$9));
            cell[5].setCellValue((String)xs.thesisTitle().getOrElse(DefenseReport$::render$$anonfun$10));
            reviews.get((Object)xs).foreach((Function1)(JProcedure1 & Serializable)review -> {
                review.crossReviewer().foreach((Function1)(JProcedure1 & Serializable)crossReviewer -> cell[6].setCellValue(crossReviewer.name()));
                review.advisorScore().foreach((Function1)(JFunction1.mcVI.sp & Serializable)advisorScore -> cell[7].setCellValue(Int$.MODULE$.int2double(advisorScore)));
                review.crossReviewScore().foreach((Function1)(JFunction1.mcVF.sp & Serializable)score -> cell[8].setCellValue(Float$.MODULE$.float2double(score)));
                review.defenseScore().foreach((Function1)(JFunction1.mcVF.sp & Serializable)score -> cell[9].setCellValue(Float$.MODULE$.float2double(score)));
                review.finalScore().foreach((Function1)(JFunction1.mcVF.sp & Serializable)score -> cell[10].setCellValue(Float$.MODULE$.float2double(score)));
            });
        }
        return hsw;
    }

    private static final String render$$anonfun$4() {
        return "--";
    }

    private static final String render$$anonfun$7() {
        return "--";
    }

    private static final String render$$anonfun$9() {
        return "--";
    }

    private static final String render$$anonfun$10() {
        return "--";
    }
}

