/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.attendance.web.action.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.ZoneId;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.model.Entity;
import org.beangle.doc.excel.schema.ExcelColumn;
import org.beangle.doc.excel.schema.ExcelScheet;
import org.beangle.doc.excel.schema.ExcelSchema;
import org.beangle.doc.transfer.importer.ImportSetting;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.annotation.param;
import org.beangle.webmvc.annotation.response;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.action.ImportSupport;
import org.beangle.webmvc.support.action.RestfulAction;
import org.beangle.webmvc.view.Stream$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.service.ProjectConfigService;
import org.openurp.base.service.SemesterService;
import org.openurp.code.service.CodeService;
import org.openurp.edu.attendance.model.LeaveType$;
import org.openurp.edu.attendance.model.StdLeave;
import org.openurp.edu.attendance.model.StdLeaveLesson;
import org.openurp.edu.attendance.web.action.admin.StdLeaveImportListener;
import org.openurp.edu.attendance.web.action.admin.StdLeaveService;
import org.openurp.starter.web.support.ProjectSupport;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class StdLeaveAction
extends RestfulAction<StdLeave>
implements ProjectSupport,
ImportSupport<StdLeave>,
ExportSupport<StdLeave> {
    private CodeService codeService;
    private ProjectConfigService configService;
    private SemesterService semesterService;
    private StdLeaveService stdLeaveService;

    public StdLeaveAction() {
        ProjectSupport.$init$((ProjectSupport)this);
    }

    public CodeService codeService() {
        return this.codeService;
    }

    public ProjectConfigService configService() {
        return this.configService;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void codeService_$eq(CodeService x$1) {
        this.codeService = x$1;
    }

    public void configService_$eq(ProjectConfigService x$1) {
        this.configService = x$1;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public StdLeaveService stdLeaveService() {
        return this.stdLeaveService;
    }

    public void stdLeaveService_$eq(StdLeaveService x$1) {
        this.stdLeaveService = x$1;
    }

    public void indexSetting() {
        LazyRef lazyRef = new LazyRef();
        this.put("project", (Object)this.project$1(lazyRef));
        this.put("semester", (Object)this.getSemester(this.project$1(lazyRef)));
        this.put("leaveTypes", (Object)LeaveType$.MODULE$.values());
        this.put("departs", (Object)this.getDeparts(this.project$1(lazyRef)));
        super.indexSetting();
    }

    public void editSetting(StdLeave entity) {
        LazyRef lazyRef = new LazyRef();
        this.put("project", (Object)this.project$2(lazyRef));
        this.put("semester", (Object)this.getSemester(this.project$2(lazyRef)));
        super.editSetting((Entity)entity);
    }

    public OqlBuilder<StdLeave> getQueryBuilder() {
        OqlBuilder query = EntityAction.getQueryBuilder$((EntityAction)this);
        this.getDate("leaveOn").foreach((Function1 & Serializable)date -> (OqlBuilder)query.where(":leaveOn between date(stdLeave.beginAt) and date(stdLeave.endAt)", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date})));
        return query;
    }

    public View generateLeaveLessons() {
        scala.collection.immutable.Seq leaves = this.entityDao().find(StdLeave.class, (Iterable)this.getLongIds("stdLeave"));
        IntRef i = IntRef.create((int)0);
        leaves.foreach((Function1)(JProcedure1 & Serializable)leave -> {
            boolean success = this.stdLeaveService().generateLeaveLessons(leave);
            scala.collection.immutable.Seq exists = this.entityDao().findBy(StdLeaveLesson.class, "leave", leave);
            if (success) {
                ++i$1.elem;
                return;
            }
        });
        return this.redirect("search", "\u751f\u6210\u6210\u529f" + i.elem + "\u4e2a\u8bf7\u5047\u8bfe\u7a0b");
    }

    @response
    public Object downloadTemplate() {
        LazyRef lazyRef = new LazyRef();
        Object object = Predef$.MODULE$.refArrayOps((Object[])LeaveType$.MODULE$.values());
        Object[] leaveTypes = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> x.name(), ClassTag$.MODULE$.apply(String.class));
        ExcelSchema schema = new ExcelSchema();
        ExcelScheet sheet = schema.createScheet("\u6570\u636e\u6a21\u677f");
        sheet.title("\u8bf7\u5047\u4fe1\u606f\u6a21\u677f");
        sheet.remark("\u7279\u522b\u8bf4\u660e\uff1a\n1\u3001\u4e0d\u53ef\u6539\u53d8\u672c\u8868\u683c\u7684\u884c\u5217\u7ed3\u6784\u4ee5\u53ca\u6279\u6ce8\uff0c\u5426\u5219\u5c06\u4f1a\u5bfc\u5165\u5931\u8d25\uff01\n2\u3001\u5fc5\u987b\u6309\u7167\u89c4\u683c\u8bf4\u660e\u7684\u683c\u5f0f\u586b\u5199\u3002\n3\u3001\u53ef\u4ee5\u591a\u6b21\u5bfc\u5165\uff0c\u91cd\u590d\u7684\u4fe1\u606f\u4f1a\u88ab\u65b0\u6570\u636e\u66f4\u65b0\u8986\u76d6\u3002\n4\u3001\u4fdd\u5b58\u7684excel\u6587\u4ef6\u540d\u79f0\u53ef\u4ee5\u81ea\u5b9a\u3002");
        ExcelColumn excelColumn = sheet.add("\u5b66\u53f7", "std.code").length(15);
        excelColumn.required(excelColumn.required$default$1()).remark("\u226415\u4f4d");
        ExcelColumn excelColumn2 = sheet.add("\u7c7b\u578b", "leaveType").ref((Seq)Predef$.MODULE$.wrapRefArray(leaveTypes));
        excelColumn2.required(excelColumn2.required$default$1());
        ExcelColumn excelColumn3 = sheet.add("\u8d77\u59cb\u65f6\u95f4", "stdLeave.beginAt").remark("yyyy-MM-dd HH:mm:ss").datatime();
        excelColumn3.required(excelColumn3.required$default$1());
        ExcelColumn excelColumn4 = sheet.add("\u7ed3\u675f\u65f6\u95f4", "stdLeave.endAt").remark("yyyy-MM-dd HH:mm:ss").datatime();
        excelColumn4.required(excelColumn4.required$default$1());
        ExcelColumn excelColumn5 = sheet.add("\u4e8b\u7531", "stdLeave.reason").remark("100\u5b57\u4ee5\u5185");
        excelColumn5.required(excelColumn5.required$default$1());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        schema.generate((OutputStream)os);
        return Stream$.MODULE$.apply((InputStream)new ByteArrayInputStream(os.toByteArray()), MediaTypes$.MODULE$.ApplicationXlsx(), "\u5b66\u751f\u8bf7\u5047\u4fe1\u606f.xlsx", Stream$.MODULE$.apply$default$4());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        StdLeave leave = (StdLeave)this.entityDao().get(StdLeave.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        scala.collection.immutable.Seq lessons = this.entityDao().findBy(StdLeaveLesson.class, "leave", (Object)leave);
        this.put("leave", (Object)leave);
        this.put("lessons", (Object)lessons);
        return this.forward(this.forward$default$1());
    }

    public View saveAndRedirect(StdLeave leave) {
        leave.semester_$eq(this.semesterService().get(this.getProject(), leave.beginAt().atZone(ZoneId.systemDefault()).toLocalDate()));
        this.entityDao().saveOrUpdate((Object)leave, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StdLeave[0]));
        this.stdLeaveService().generateLeaveLessons(leave);
        return super.saveAndRedirect((Entity)leave);
    }

    public void configImport(ImportSetting setting) {
        setting.listeners_$eq((List)new .colon.colon((Object)new StdLeaveImportListener(this.entityDao(), this.semesterService(), this.stdLeaveService(), this.getProject()), (List)Nil$.MODULE$));
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }

    private final Project project$lzyINIT2$1(LazyRef project$lzy2$1) {
        Project project;
        LazyRef lazyRef = project$lzy2$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy2$1.initialized() ? project$lzy2$1.value() : project$lzy2$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$2(LazyRef project$lzy2$2) {
        return (Project)(project$lzy2$2.initialized() ? project$lzy2$2.value() : this.project$lzyINIT2$1(project$lzy2$2));
    }

    private final Project project$lzyINIT3$1(LazyRef project$lzy3$1) {
        Project project;
        LazyRef lazyRef = project$lzy3$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy3$1.initialized() ? project$lzy3$1.value() : project$lzy3$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$3(LazyRef project$lzy3$2) {
        return (Project)(project$lzy3$2.initialized() ? project$lzy3$2.value() : this.project$lzyINIT3$1(project$lzy3$2));
    }
}

