/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.attendance.web.action.admin;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.edu.attendance.model.StdLeave;
import org.openurp.edu.attendance.model.StdLeaveLesson;
import org.openurp.edu.attendance.web.action.admin.StdLeaveService;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.schedule.service.LessonSchedule$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class StdLeaveServiceImpl
implements StdLeaveService {
    private EntityDao entityDao;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public boolean generateLeaveLessons(StdLeave leave) {
        scala.collection.immutable.Seq exists = this.entityDao().findBy(StdLeaveLesson.class, "leave", (Object)leave);
        Duration duration = Duration.between(leave.beginAt(), leave.endAt());
        leave.days_$eq((int)Math.ceil((double)duration.getSeconds() / 86400.0));
        if (exists.isEmpty()) {
            OqlBuilder takerQuery = OqlBuilder$.MODULE$.from(CourseTaker.class, "ct");
            takerQuery.where("ct.std=:std and ct.semester=:semester", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leave.std(), leave.semester()}));
            scala.collection.immutable.Seq takers = this.entityDao().search((QueryBuilder)takerQuery);
            scala.collection.immutable.Seq activities = (scala.collection.immutable.Seq)takers.flatMap((Function1 & Serializable)_$2 -> _$2.clazz().schedule().activities());
            LocalDateTime bAt = leave.beginAt().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime eAt = leave.endAt().atZone(ZoneId.systemDefault()).toLocalDateTime();
            Seq schedules = LessonSchedule$.MODULE$.convert((Iterable)activities, bAt, eAt);
            Seq leaveLessons = (Seq)schedules.map((Function1 & Serializable)s -> {
                StdLeaveLesson ll = new StdLeaveLesson();
                ll.std_$eq(leave.std());
                Clazz clazz = (Clazz)this.entityDao().get(Clazz.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s.task().id()))));
                ll.clazz_$eq(clazz);
                ll.semester_$eq(clazz.semester());
                ll.leaveType_$eq(leave.leaveType());
                ll.lessonOn_$eq(s.date());
                ll.lessonTime_$eq(s.time());
                ll.leave_$eq((Option)Some$.MODULE$.apply((Object)leave));
                return ll;
            });
            leave.lessons_$eq(leaveLessons.size());
            this.entityDao().saveOrUpdate((Iterable)leaveLessons);
            this.entityDao().saveOrUpdate((Object)leave, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StdLeave[0]));
            return true;
        }
        this.entityDao().saveOrUpdate((Object)leave, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StdLeave[0]));
        return false;
    }
}

