/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.web.action;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Order$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.model.Entity;
import org.beangle.data.transfer.importer.ImportSetting;
import org.beangle.data.transfer.importer.listener.ForeignerListener;
import org.beangle.webmvc.api.view.View;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.AcademicLevel;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.base.code.model.CourseCategory;
import org.openurp.edu.base.code.model.CourseHourType;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.CourseHour;
import org.openurp.edu.base.web.action.ProjectRestfulAction;
import org.openurp.edu.base.web.helper.CourseImportListener;
import org.openurp.edu.base.web.helper.QueryHelper$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Shrinkable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]3A\u0001C\u0005\u0001-!)\u0011\u0005\u0001C\u0001E!)A\u0005\u0001C)K!)A\u0006\u0001C![!)\u0001\b\u0001C!s!)A\b\u0001C){!)\u0011\n\u0001C)\u0015\")Q\u000b\u0001C\u0001-\na1i\\;sg\u0016\f5\r^5p]*\u0011!bC\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u00051i\u0011aA<fE*\u0011abD\u0001\u0005E\u0006\u001cXM\u0003\u0002\u0011#\u0005\u0019Q\rZ;\u000b\u0005I\u0019\u0012aB8qK:,(\u000f\u001d\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0006\t\u00041eYR\"A\u0005\n\u0005iI!\u0001\u0006)s_*,7\r\u001e*fgR4W\u000f\\!di&|g\u000e\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u001b\u0005)Qn\u001c3fY&\u0011\u0001%\b\u0002\u0007\u0007>,(o]3\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\r\u0001\u00031Ig\u000eZ3y'\u0016$H/\u001b8h)\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSR\fqbZ3u#V,'/\u001f\"vS2$WM]\u000b\u0002]A\u0019qFN\u000e\u000e\u0003AR!!\r\u001a\u0002\u0007\u0011\fwN\u0003\u00024i\u0005!A-\u0019;b\u0015\t)4#A\u0004cK\u0006tw\r\\3\n\u0005]\u0002$AC(rY\n+\u0018\u000e\u001c3fe\u0006YQ\rZ5u'\u0016$H/\u001b8h)\t1#\bC\u0003<\t\u0001\u00071$\u0001\u0004f]RLG/_\u0001\u0010g\u00064X-\u00118e%\u0016$\u0017N]3diR\u0011a\b\u0013\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bAA^5fo*\u00111\tR\u0001\u0004CBL'BA#5\u0003\u00199XMY7wG&\u0011q\t\u0011\u0002\u0005-&,w\u000fC\u0003<\u000b\u0001\u00071$\u0001\u0007d_:4\u0017nZ%na>\u0014H\u000f\u0006\u0002'\u0017\")AJ\u0002a\u0001\u001b\u000691/\u001a;uS:<\u0007C\u0001(T\u001b\u0005y%B\u0001)R\u0003!IW\u000e]8si\u0016\u0014(B\u0001*3\u0003!!(/\u00198tM\u0016\u0014\u0018B\u0001+P\u00055IU\u000e]8siN+G\u000f^5oO\u0006Qa.Z<D_V\u00148/Z:\u0015\u0003y\u0002")
public class CourseAction
extends ProjectRestfulAction<Course> {
    public void indexSetting() {
        this.put("courseTypes", this.getCodes(CourseType.class));
        this.put("courseCategories", this.getCodes(CourseCategory.class));
        Seq<Department> departments = this.findInSchool(Department.class);
        this.put("departments", departments);
    }

    @Override
    public OqlBuilder<Course> getQueryBuilder() {
        OqlBuilder builder = OqlBuilder$.MODULE$.from(this.entityName(), this.simpleEntityName());
        this.getDate("beginOn").foreach((Function1 & Serializable)beginOn -> {
            CourseAction.$anonfun$getQueryBuilder$1(this, builder, beginOn);
            return BoxedUnit.UNIT;
        });
        this.populateConditions(builder);
        builder.where(new StringBuilder(19).append(this.simpleEntityName()).append(".project = :project").toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        builder.orderBy((String)this.get(Order$.MODULE$.OrderStr()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).limit(this.getPageLimit());
        return QueryHelper$.MODULE$.addTemporalOn(builder, (Option<Object>)this.getBoolean("active"));
    }

    public void editSetting(Course entity) {
        this.put("courseTypes", this.getCodes(CourseType.class));
        this.put("examModes", this.getCodes(ExamMode.class));
        this.put("gradingModes", this.getCodes(GradingMode.class));
        this.put("courseCategories", this.getCodes(CourseCategory.class));
        this.put("departments", this.findInSchool(Department.class));
        Buffer levels = ((IterableOnceOps)this.getProject().levels().map((Function1 & Serializable)x$1 -> x$1.toLevel())).toSet().toBuffer();
        levels.$minus$minus$eq((IterableOnce)entity.levels());
        this.put("levels", levels);
        this.put("hourTypes", this.getCodes(CourseHourType.class));
        if (!entity.persisted()) {
            entity.project_$eq(this.getProject());
            entity.beginOn_$eq(LocalDate.now());
            entity.levels().$plus$plus$eq((IterableOnce)levels);
            levels.clear();
        }
        super.editSetting((Entity)entity);
    }

    @Override
    public View saveAndRedirect(Course entity) {
        Course course = entity;
        Seq<CourseHourType> hourTypes = this.getCodes(CourseHourType.class);
        hourTypes.foreach((Function1 & Serializable)ht -> {
            BoxedUnit boxedUnit;
            Option creditHour = this.getInt(new StringBuilder(10).append("creditHour").append(ht.id()).toString());
            Option week = this.getInt(new StringBuilder(4).append("week").append(ht.id()).toString());
            Option option = course.hours().find((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)CourseAction.$anonfun$saveAndRedirect$2(ht, h)));
            if (option instanceof Some) {
                Shrinkable shrinkable;
                Some some = (Some)option;
                CourseHour hour = (CourseHour)some.value();
                if (week.isEmpty() && creditHour.isEmpty()) {
                    shrinkable = course.hours().$minus$eq((Object)hour);
                } else {
                    hour.weeks_$eq(BoxesRunTime.unboxToInt((Object)week.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
                    hour.creditHours_$eq(BoxesRunTime.unboxToInt((Object)creditHour.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
                    shrinkable = BoxedUnit.UNIT;
                }
                boxedUnit = shrinkable;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit2;
                if (!week.isEmpty() || !creditHour.isEmpty()) {
                    CourseHour newHour = new CourseHour();
                    newHour.course_$eq(course);
                    newHour.hourType_$eq(ht);
                    newHour.weeks_$eq(BoxesRunTime.unboxToInt((Object)week.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
                    newHour.creditHours_$eq(BoxesRunTime.unboxToInt((Object)creditHour.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)));
                    boxedUnit2 = course.hours().$plus$eq((Object)newHour);
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else {
                throw new MatchError((Object)option);
            }
            return boxedUnit;
        });
        Buffer orphan = (Buffer)course.hours().filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CourseAction.$anonfun$saveAndRedirect$7(hourTypes, x)));
        course.hours().$minus$minus$eq((IterableOnce)orphan);
        Iterable levelIds = this.getAll("levelId2nd", Integer.TYPE, (ClassTag)ClassTag$.MODULE$.Int());
        Seq newLevels = this.entityDao().find(AcademicLevel.class, levelIds);
        Set removed = (Set)course.levels().filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CourseAction.$anonfun$saveAndRedirect$8(newLevels, x)));
        course.levels().subtractAll((IterableOnce)removed);
        newLevels.foreach((Function1 & Serializable)l -> !course.levels().contains(l) ? course.levels().$plus$eq(l) : BoxedUnit.UNIT);
        course.gradingModes().clear();
        Iterable gradingModeIds = this.getAll("gradingModeId2nd", Integer.TYPE, (ClassTag)ClassTag$.MODULE$.Int());
        course.gradingModes().$plus$plus$eq((IterableOnce)this.entityDao().find(GradingMode.class, gradingModeIds));
        return super.saveAndRedirect(entity);
    }

    public void configImport(ImportSetting setting) {
        ForeignerListener fl = new ForeignerListener(this.entityDao());
        fl.addForeigerKey("name");
        setting.listeners_$eq((List)new .colon.colon((Object)fl, (List)new .colon.colon((Object)new CourseImportListener(this.entityDao()), (List)Nil$.MODULE$)));
    }

    public View newCourses() {
        this.getDate("beginOn").foreach((Function1 & Serializable)beginOn -> {
            CourseAction.$anonfun$newCourses$1(this, beginOn);
            return BoxedUnit.UNIT;
        });
        return this.forward(this.forward$default$1());
    }

    public static final /* synthetic */ void $anonfun$getQueryBuilder$1(CourseAction $this, OqlBuilder builder$1, LocalDate beginOn) {
        $this.getDate("endOn").foreach((Function1 & Serializable)endOn -> (OqlBuilder)builder$1.where("course.beginOn between :beginOn and :endOn", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{beginOn, endOn})));
    }

    public static final /* synthetic */ boolean $anonfun$saveAndRedirect$2(CourseHourType ht$1, CourseHour h) {
        CourseHourType courseHourType = h.hourType();
        CourseHourType courseHourType2 = ht$1;
        return !(courseHourType != null ? !courseHourType.equals(courseHourType2) : courseHourType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$saveAndRedirect$7(Seq hourTypes$1, CourseHour x) {
        return !hourTypes$1.contains((Object)x.hourType());
    }

    public static final /* synthetic */ boolean $anonfun$saveAndRedirect$8(Seq newLevels$1, AcademicLevel x) {
        return !newLevels$1.contains((Object)x);
    }

    public static final /* synthetic */ void $anonfun$newCourses$1(CourseAction $this, LocalDate beginOn) {
        $this.getDate("endOn").foreach((Function1 & Serializable)endOn -> {
            $this.put("courses", $this.entityDao().search($this.getQueryBuilder()));
            return BoxedUnit.UNIT;
        });
    }
}

