/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2005, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.data.dao.OqlBuilder
import org.beangle.data.model.Entity
import org.beangle.webmvc.api.view.View
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.edu.base.code.model.{ EduSpan, StdLabel, StdType }
import org.openurp.edu.base.model.Project
import scala.collection.mutable.Buffer
import org.openurp.edu.base.code.model.EduSpan
import org.openurp.edu.base.model.TimeSetting
import org.openurp.base.model.Department
import org.openurp.base.model.Campus
import org.openurp.base.model.School
import org.openurp.edu.base.model.Calendar

class ProjectAction extends RestfulAction[Project] {
  override def editSetting(entity: Project) = {

    val school = entity.school

    val schools = findItems(classOf[School])
    put("schools", schools)

    val calendars = findItemsBySchool(classOf[Calendar], school)
    put("calendars", calendars -- entity.calendars)

    val campuses = findItemsBySchool(classOf[Campus], school)
    put("campuses", campuses -- entity.campuses)

    val departments = findItemsBySchool(classOf[Department], school)
    put("departments", departments -- entity.departments)

    val spans = findItems(classOf[EduSpan])
    put("spans", spans -- entity.spans)

    val labels = findItems(classOf[StdLabel])
    put("labels", labels -- entity.stdLabels)

    val types = findItems(classOf[StdType])
    put("types", types -- entity.stdTypes)

    super.editSetting(entity)
  }

  private def findItems[T <: Entity[_]](clazz: Class[T]): Buffer[T] = {
    val query = OqlBuilder.from(clazz)
    entityDao.search(query).toBuffer
  }

  private def findItemsBySchool[T <: Entity[_]](clazz: Class[T], school: School): Buffer[T] = {
    val query = OqlBuilder.from(clazz, "aa")
    query.where("aa.school=:school", school)
    entityDao.search(query).toBuffer
  }

  private def findItemsByProject[T <: Entity[_]](clazz: Class[T], project: Project): Buffer[T] = {
    val query = OqlBuilder.from(clazz, "aa")
    query.where("aa.school=:project", project)
    entityDao.search(query).toBuffer
  }

  protected override def saveAndRedirect(entity: Project): View = {

    entity.campuses.clear()
    val campusIds = getAll("campusesId2nd", classOf[Int])
    entity.campuses ++= entityDao.find(classOf[Campus], campusIds)

    entity.departments.clear()
    val departmentIds = getAll("departmentsId2nd", classOf[Int])
    entity.departments ++= entityDao.find(classOf[Department], departmentIds)

    entity.spans.clear()
    val spanIds = getAll("spanId2nd", classOf[Int])
    entity.spans ++= entityDao.find(classOf[EduSpan], spanIds)

    entity.stdLabels.clear()
    val labelsIds = getAll("labelsId2nd", classOf[Int])
    entity.stdLabels ++= entityDao.find(classOf[StdLabel], labelsIds)

    entity.stdTypes.clear()
    val typesIds = getAll("typesId2nd", classOf[Int])
    entity.stdTypes ++= entityDao.find(classOf[StdType], typesIds)

    entity.calendars.clear()
    val calendarIds = getAll("calendarId2nd", classOf[Int])
    entity.calendars ++= entityDao.find(classOf[Calendar], calendarIds)

    super.saveAndRedirect(entity)
  }

}
