/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2005, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.commons.collection.Order
import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.api.annotation.action
import org.beangle.webmvc.api.annotation.ignore
import org.beangle.webmvc.api.view.View
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.base.model.School
import org.openurp.edu.base.model.Holiday
import org.openurp.edu.base.code.model.DayPart
import org.openurp.edu.base.model.CourseUnit
import org.openurp.edu.base.model.TimeSetting
import org.openurp.edu.base.model.Project

class HolidayAction extends RestfulAction[Holiday] {
  override protected def getQueryBuilder(): OqlBuilder[Holiday] = {
    val builder: OqlBuilder[Holiday] = OqlBuilder.from(entityName, "holiday")
    populateConditions(builder)
    builder.orderBy(get(Order.OrderStr).orNull).limit(getPageLimit)
  }

  override protected def editSetting(entity: Holiday): Unit = {
    put("schools", entityDao.getAll(classOf[School]))
  }
}

@action("{project}/time-setting")
class TimeSettingAction extends ProjectRestfulAction[TimeSetting]

@action("{project}/course-unit")
class CourseUnitAction extends RestfulAction[CourseUnit] {

  override protected def getQueryBuilder(): OqlBuilder[CourseUnit] = {
    val builder: OqlBuilder[CourseUnit] = OqlBuilder.from(entityName, "courseUnit")
    builder.where("courseUnit.setting.project.code=:projectCode", get("project").get)
    populateConditions(builder)
    builder.orderBy(get(Order.OrderStr).orNull).limit(getPageLimit)
  }

  override protected def editSetting(entity: CourseUnit): Unit = {
    val project = entityDao.findBy(classOf[Project], "code", List(get("project").get))
    put("settings", entityDao.findBy(classOf[TimeSetting], "project", project))
    put("parts", entityDao.getAll(classOf[DayPart]))
  }

}
