/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2005, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.data.dao.EntityDao
import org.beangle.data.transfer.importer.ImportResult
import org.beangle.data.transfer.importer.ImportListener

/**
 * @author xinzhou
 */
class SquadImportListener(entityDao: EntityDao) extends ImportListener {
  override def onItemFinish(tr: ImportResult) {
    entityDao.saveOrUpdate(tr.transfer.current)
  }
  /**
   * 结束转换
   */
  override def onStart(tr: ImportResult) {}

  /**
   * 结束转换
   */
  override def onFinish(tr: ImportResult) {}

  /**
   * 开始转换单个项目
   */
  override def onItemStart(tr: ImportResult) {}

}
