/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web

import org.beangle.cdi.bind.BindModule
import org.openurp.edu.base.web.action.{ CalendarAction, ClassroomAction, CourseAction, CourseUnitAction, DirectionAction, DirectionJournalAction, HolidayAction, MajorAction, MajorDisciplineAction, MajorJournalAction, ProjectAction, ProjectCodeAction, SemesterAction, SquadAction, TeacherAction, TimeSettingAction }
import org.openurp.edu.base.web.action.code.{ CourseAbilityRateAction, CourseHourTypeAction, CourseTypeAction, EducationLevelAction, ExamModeAction, ExamStatusAction, GradingModeAction, StdLabelAction, StdLabelTypeAction, StdTypeAction }

class DefaultModule extends BindModule {

  protected override def binding() {
    bind(classOf[SquadAction], classOf[MajorAction], classOf[DirectionAction], classOf[DirectionJournalAction], classOf[MajorJournalAction], classOf[MajorDisciplineAction])
    bind(classOf[ProjectAction], classOf[ProjectCodeAction])
    bind(classOf[CourseAction], classOf[CourseHourTypeAction])
    bind(classOf[StdLabelAction], classOf[StdLabelTypeAction], classOf[StdTypeAction])
    bind(classOf[ExamModeAction], classOf[ExamStatusAction])
    bind(classOf[CourseAbilityRateAction],  classOf[CourseTypeAction])
    bind(classOf[GradingModeAction])
    bind(classOf[TeacherAction])
    bind(classOf[ClassroomAction])
    bind(classOf[EducationLevelAction])

    bind(classOf[SemesterAction], classOf[CalendarAction])
    bind(classOf[TimeSettingAction], classOf[CourseUnitAction], classOf[HolidayAction])
  }
}
