/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.edu.base.model.Classroom
import org.beangle.data.dao.OqlBuilder
import org.beangle.data.model.Entity
import org.openurp.code.edu.model.ClassroomType
import org.openurp.base.model.Room
import org.openurp.base.model.School
import scala.collection.mutable.Buffer
import org.beangle.webmvc.api.annotation.action
import org.openurp.base.model.Campus
import org.beangle.webmvc.api.view.View
import org.openurp.edu.base.web.action.helper.QueryHelper
import java.time.Instant
import java.time.LocalDate

@action("{project}/classroom")
class ClassroomAction extends ProjectRestfulAction[Classroom] {

  protected override def indexSetting(): Unit = {
    val roomTypes = findItems(classOf[ClassroomType])
    put("roomTypes", roomTypes)
  }

  override def getQueryBuilder(): OqlBuilder[Classroom] = {
    QueryHelper.addTemporalOn(super.getQueryBuilder(), getBoolean("active"))
  }

  override protected def saveAndRedirect(entity: Classroom): View = {
    entity.updatedAt = Instant.now
    entity.beginOn = LocalDate.now()
    super.saveAndRedirect(entity)
  }

  override def editSetting(entity: Classroom) = {

    if (null == entity.project) {
      entity.project = currentProject
    }
    val roomTypes = findItems(classOf[ClassroomType])
    put("roomTypes", roomTypes)

    val campuses = findItemsBySchool(classOf[Campus])
    put("campuses", campuses)

    val rooms = findItemsBySchool(classOf[Room])
    put("rooms", rooms)
  }

}
