/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.webmvc.api.annotation.action
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.base.model.Department
import org.openurp.code.edu.model.{ DisciplineCategory, EducationLevel }
import org.openurp.edu.base.model.MajorJournal

@action("{project}/major-journal")
class MajorJournalAction extends RestfulAction[MajorJournal] with ProjectSupport {

  override def editSetting(entity: MajorJournal) = {

    put("categories", findItems(classOf[DisciplineCategory]))

    put("levels", findItems(classOf[EducationLevel]))

    put("departs", findItemsBySchool(classOf[Department]))

    super.editSetting(entity)
  }

}
