/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web

import org.beangle.cdi.bind.BindModule
import org.openurp.edu.base.web.action._
import org.openurp.edu.base.web.action.CodeAction
import org.openurp.edu.base.web.action.code._

class DefaultModule extends BindModule {

  protected override def binding() {
    bind(classOf[SquadAction], classOf[MajorAction], classOf[DirectionAction], classOf[DirectionJournalAction], classOf[MajorJournalAction], classOf[MajorDisciplineAction])
    bind(classOf[ProjectAction], classOf[ProjectCodeAction])
    bind(classOf[CourseAction])
    bind(classOf[TeacherAction])
    bind(classOf[ClassroomAction])
    bind(classOf[TextbookAction])
    bind(classOf[SchoolLengthAction])

    bind(classOf[SemesterAction], classOf[CalendarAction])
    bind(classOf[TimeSettingAction], classOf[CourseUnitAction], classOf[HolidayAction])

    //code mapping
    bind(classOf[CodeAction])
    bind(classOf[StdLabelAction], classOf[StdLabelTypeAction], classOf[StdTypeAction])
    bind(classOf[CourseAbilityRateAction], classOf[CourseTypeAction])
    bind(classOf[CourseHourTypeAction], classOf[GradingModeAction])
    bind(classOf[CourseCategoryAction])
    bind(classOf[ExamModeAction], classOf[ExamStatusAction])
    bind(classOf[EducationLevelAction])
    bind(classOf[StdAlterTypeAction], classOf[StdAlterReasonAction])

    bind(classOf[PressAction], classOf[BookTypeAction], classOf[BookAwardTypeAction])
    bind(classOf[BookCategoryAction],classOf[PressGradeAction])
  }
}
