/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import java.time.LocalDate

import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.api.view.View
import org.openurp.code.sin.model.BookCategory
import org.openurp.code.sin.model.Press
import org.openurp.edu.base.code.model.BookAwardType
import org.openurp.edu.base.code.model.BookType
import org.openurp.edu.base.model.Textbook

class TextbookAction extends ProjectRestfulAction[Textbook] {

  protected override def editSetting(textbook: Textbook): Unit = {
    put("bookTypes", getCodes(classOf[BookType]))
    put("presses", getCodes(classOf[Press]))
    put("awardTypes", getCodes(classOf[BookAwardType]))
    put("categories", getCodes(classOf[BookCategory]))
  }

  override protected def getQueryBuilder: OqlBuilder[Textbook] = {
    val builder: OqlBuilder[Textbook] = super.getQueryBuilder
    getBoolean("active") foreach {
      case true =>
        builder.where("textbook.endOn is null or textbook.endOn >=:now", LocalDate.now)
      case false =>
        builder.where("textbook.endOn is not null and textbook.endOn <:now", LocalDate.now)
    }
    builder
  }

  def innerIndex(): View = {
    forward()
  }

  protected override def saveAndRedirect(book: Textbook): View = {
    if (null == book.beginOn) {
      book.beginOn = LocalDate.now
    }
    return super.saveAndRedirect(book)
  }
}
