/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action.code

import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.code.edu.model.{EducationLevel, ExamMode, ExamStatus, GradingMode}
import org.openurp.code.edu.model.StdAlterReason
import org.openurp.code.edu.model.StdAlterType
import org.openurp.code.sin.model.Press
import org.openurp.edu.base.code.model._
import org.openurp.edu.base.code.model.CourseCategory
import org.openurp.edu.base.code.model.BookType
import org.openurp.code.sin.model.BookCategory
import org.openurp.code.sin.model.PressGrade

class StdLabelAction extends RestfulAction[StdLabel] {
  override def editSetting(entity: StdLabel) = {
    val query = OqlBuilder.from(classOf[StdLabelType])
    query.orderBy("name")
    val labelTypes = entityDao.search(query)
    put("labelTypes", labelTypes)
    super.editSetting(entity)
  }
}

class StdLabelTypeAction extends RestfulAction[StdLabelType]

class StdTypeAction extends RestfulAction[StdType]

class CourseAbilityRateAction extends RestfulAction[CourseAbilityRate]

class CourseHourTypeAction extends RestfulAction[CourseHourType]

class CourseTypeAction extends RestfulAction[CourseType]

class CourseCategoryAction extends RestfulAction[CourseCategory]

class GradingModeAction extends RestfulAction[GradingMode]

class ExamModeAction extends RestfulAction[ExamMode]

class ExamStatusAction extends RestfulAction[ExamStatus]

class EducationLevelAction extends RestfulAction[EducationLevel]

class StdAlterTypeAction extends RestfulAction[StdAlterType]

class StdAlterReasonAction extends RestfulAction[StdAlterReason]

class BookTypeAction extends RestfulAction[BookType]

class BookAwardTypeAction extends RestfulAction[BookAwardType]

class PressAction extends RestfulAction[Press]{
   override def editSetting(entity: Press) = {
     put("grades",entityDao.getAll(classOf[PressGrade]))
   }
}

class BookCategoryAction extends RestfulAction[BookCategory]

class PressGradeAction extends RestfulAction[PressGrade]
