/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import java.time.{Instant, LocalDate}

import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.api.view.View
import org.openurp.base.model.{Campus, Room}
import org.openurp.code.edu.model.ClassroomType
import org.openurp.edu.base.model.Classroom
import org.openurp.edu.base.web.action.helper.QueryHelper

class ClassroomAction extends ProjectRestfulAction[Classroom] {

  protected override def indexSetting(): Unit = {
    put("roomTypes", getCodes(classOf[ClassroomType]))
    put("campuses", findInSchool(classOf[Campus]))
  }

  override def getQueryBuilder: OqlBuilder[Classroom] = {
    val builder = super.getQueryBuilder
    QueryHelper.addTemporalOn(builder, getBoolean("active"))
    getBoolean("virtual") foreach { virtual =>
      builder.where(if (virtual) "classroom.room is null" else "classroom.room is not null")
    }
    builder
  }

  override protected def saveAndRedirect(entity: Classroom): View = {
    entity.updatedAt = Instant.now
    entity.beginOn = LocalDate.now()
    super.saveAndRedirect(entity)
  }

  override def editSetting(entity: Classroom) = {
    if (null == entity.project) {
      entity.project = getProject
    }
    put("roomTypes", getCodes(classOf[ClassroomType]))
    put("campuses", findInSchool(classOf[Campus]))
    put("rooms", findInSchool(classOf[Room]))
  }

}
