/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import org.beangle.data.dao.OqlBuilder
import org.beangle.data.model.Entity
import org.beangle.webmvc.api.annotation.action
import org.openurp.edu.base.model.{ Direction, Major, MajorDiscipline, Project }
import org.beangle.webmvc.entity.action.RestfulAction
import org.openurp.edu.base.web.action.helper.QueryHelper

class MajorAction extends ProjectRestfulAction[Major] {

  override def getQueryBuilder: OqlBuilder[Major] = {
    QueryHelper.addTemporalOn(super.getQueryBuilder, getBoolean("active"))
  }

  override def editSetting(entity: Major) = {

    put("projects", List(getProject))
    val disciplines = entityDao.getAll(classOf[MajorDiscipline])
    put("disciplines", disciplines)

    if (null == entity.project) {
      entity.project = getProject
    }

    super.editSetting(entity)
  }

}
