/*
 * OpenURP, Agile University Resource Planning Solution.
 *
 * Copyright © 2014, The OpenURP Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.web.action

import java.time.Instant

import org.beangle.commons.lang.Strings
import org.beangle.data.dao.OqlBuilder
import org.beangle.webmvc.api.view.View
import org.beangle.webmvc.execution.Handler
import org.openurp.base.code.model.UserCategory
import org.openurp.base.model.{Department, Name, Person, User}
import org.openurp.code.hr.model.WorkStatus
import org.openurp.code.job.model.ProfessionalTitle
import org.openurp.code.person.model.{Gender, IdType}
import org.openurp.edu.base.code.model.TeacherType
import org.openurp.edu.base.model.Teacher
import org.openurp.edu.base.web.action.helper.QueryHelper

class TeacherSearchAction extends ProjectRestfulAction[Teacher] {

  override def getQueryBuilder: OqlBuilder[Teacher] = {
    QueryHelper.addTemporalOn(super.getQueryBuilder, getBoolean("active"))
  }

  override protected def indexSetting(): Unit = {
    put("departments", findInSchool(classOf[Department]))
    put("teacherTypes", entityDao.getAll(classOf[TeacherType]))
  }

}
