/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.AcademicLevel;
import org.openurp.edu.base.code.model.CourseAbilityRate;
import org.openurp.edu.base.code.model.CourseCategory;
import org.openurp.edu.base.code.model.CourseHourType;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.code.model.ExamMode;
import org.openurp.edu.base.code.model.GradingMode;
import org.openurp.edu.base.model.CourseHour;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.ProjectBasedObject;
import org.openurp.edu.base.model.Textbook;

@Entity(name="org.openurp.edu.base.model.Course")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class Course
extends ProjectBasedObject<Long>
implements Comparable<Course> {
    private static final long serialVersionUID = 732786365746405676L;
    @Column(unique=true)
    @NotNull
    @Size(max=32)
    protected String code;
    @NotNull
    @Size(max=255)
    protected String name;
    @Size(max=300)
    protected String enName;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<AcademicLevel> levels = CollectUtils.newHashSet();
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseCategory category;
    private float credits;
    @NotNull
    private int creditHours;
    @OneToMany(mappedBy="course", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CourseHour> hours = CollectUtils.newArrayList();
    private int weekHours;
    private Integer weeks;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType courseType;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamMode examMode;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<GradingMode> gradingModes = CollectUtils.newHashSet();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<CourseAbilityRate> abilityRates = CollectUtils.newHashSet();
    @ManyToMany
    private Set<Major> majors = CollectUtils.newHashSet();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Major> xmajors = CollectUtils.newHashSet();
    @ManyToMany
    private Set<Textbook> textbooks = CollectUtils.newHashSet();
    private Date beginOn;
    private Date endOn;
    @Size(max=500)
    protected String remark;

    public Course() {
    }

    public Course(Long id) {
        super(id);
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public CourseCategory getCategory() {
        return this.category;
    }

    public void setCategory(CourseCategory category) {
        this.category = category;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public float getCredits() {
        return this.credits;
    }

    public void setCredits(float credits) {
        this.credits = credits;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public int compareTo(Course other) {
        return Objects.compareBuilder().add((Object)this.getCode(), (Object)other.getCode()).toComparison();
    }

    public int getCreditHours() {
        return this.creditHours;
    }

    public void setCreditHours(int creditHours) {
        this.creditHours = creditHours;
    }

    public int getWeekHours() {
        return this.weekHours;
    }

    public void setWeekHours(int weekHours) {
        this.weekHours = weekHours;
    }

    public Integer getWeeks() {
        return this.weeks;
    }

    public void setWeeks(Integer weeks) {
        this.weeks = weeks;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public ExamMode getExamMode() {
        return this.examMode;
    }

    public void setExamMode(ExamMode examMode) {
        this.examMode = examMode;
    }

    public Set<CourseAbilityRate> getAbilityRates() {
        return this.abilityRates;
    }

    public void setAbilityRates(Set<CourseAbilityRate> abilityRates) {
        this.abilityRates = abilityRates;
    }

    public Set<Major> getMajors() {
        return this.majors;
    }

    public void setMajors(Set<Major> majors) {
        this.majors = majors;
    }

    public Set<Major> getXmajors() {
        return this.xmajors;
    }

    public void setXmajors(Set<Major> xmajors) {
        this.xmajors = xmajors;
    }

    public Set<Textbook> getTextbooks() {
        return this.textbooks;
    }

    public void setTextbooks(Set<Textbook> textbooks) {
        this.textbooks = textbooks;
    }

    public String getWeekHourString() {
        if (this.hours.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<CourseHour> iter = this.hours.iterator();
        while (iter.hasNext()) {
            CourseHour courseHour = iter.next();
            Integer value = courseHour.getWeekHour();
            sb.append(value);
            if (!iter.hasNext()) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    public Integer getHour(CourseHourType type) {
        for (CourseHour courseHour : this.hours) {
            if (null == type || !courseHour.getHourType().equals((Object)type)) continue;
            return courseHour.getPeriod();
        }
        return null;
    }

    public Integer getHourById(Integer typeId) {
        for (CourseHour courseHour : this.hours) {
            if (null == typeId || !((Integer)courseHour.getHourType().getId()).equals(typeId)) continue;
            return courseHour.getPeriod();
        }
        return null;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.code).add("name", (Object)this.name).toString();
    }

    public List<CourseHour> getHours() {
        return this.hours;
    }

    public void setHours(List<CourseHour> courseHours) {
        this.hours = courseHours;
    }

    public Set<AcademicLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(Set<AcademicLevel> levels) {
        this.levels = levels;
    }

    public Set<GradingMode> getGradingModes() {
        return this.gradingModes;
    }

    public void setGradingModes(Set<GradingMode> gradingModes) {
        this.gradingModes = gradingModes;
    }

    public boolean isEnabled() {
        return null == this.endOn;
    }

    public void setEnabled(boolean e) {
        if (e) {
            if (null == this.beginOn) {
                this.beginOn = new Date(System.currentTimeMillis());
            }
            this.endOn = null;
        } else {
            this.endOn = new Date(System.currentTimeMillis());
        }
    }
}

