/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.code.edu.model.Degree;
import org.openurp.code.edu.model.StudyType;
import org.openurp.edu.base.code.model.EduSpan;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.AuditState;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.Project;

@Cacheable
@Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Entity(name="org.openurp.edu.base.model.Program")
public class Program
extends NumberIdTimeObject<Long>
implements Cloneable {
    private static final long serialVersionUID = 4260627210556648248L;
    @NotNull
    @Size(max=200)
    private String name;
    @NotNull
    private String grade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private EduSpan span;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @NotNull
    private Float duration;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private StudyType studyType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Degree degree;
    @NotNull
    private Date beginOn;
    private Date endOn;
    @Size(max=800)
    private String remark;
    private Float degreeGpa;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private AuditState state = AuditState.UNSUBMITTED;

    public Program() {
    }

    public Program(Long id) {
        super((Number)id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public EduSpan getSpan() {
        return this.span;
    }

    public void setSpan(EduSpan span) {
        this.span = span;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public StudyType getStudyType() {
        return this.studyType;
    }

    public void setStudyType(StudyType studyType) {
        this.studyType = studyType;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public AuditState getState() {
        return this.state;
    }

    public void setState(AuditState auditState) {
        this.state = auditState;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public Float getDegreeGpa() {
        return this.degreeGpa;
    }

    public void setDegreeGpa(Float degreeGpa) {
        this.degreeGpa = degreeGpa;
    }
}

