/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdObject;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.tuple.Pair;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.openurp.base.model.Campus;
import org.openurp.edu.base.model.CourseUnit;
import org.openurp.edu.base.model.Project;

@Entity(name="org.openurp.edu.base.model.TimeSetting")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class TimeSetting
extends NumberIdObject<Integer> {
    private static final long serialVersionUID = 3359358617662801996L;
    @NotNull
    @Size(max=100)
    private String name;
    @OrderBy(value="indexno")
    @Cascade(value={CascadeType.ALL})
    @OneToMany(targetEntity=CourseUnit.class, mappedBy="setting")
    private List<CourseUnit> units = CollectUtils.newArrayList();
    private short minutesPerUnit;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @NotNull
    protected Date beginOn;
    protected Date endOn;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, CourseUnit> getUnitMap() {
        Map rs = CollectUtils.newHashMap();
        for (CourseUnit unit : this.units) {
            rs.put(unit.getIndexno(), unit);
        }
        return rs;
    }

    public Pair<Integer, Integer> getUnitSpan(HourMinute first, HourMinute second) {
        int startUnit = 100;
        int endUnit = 0;
        CourseUnit testUnit = new CourseUnit(first, second);
        for (CourseUnit unit : this.units) {
            if (!CourseUnit.isCrossWith(unit, testUnit)) continue;
            if (unit.getIndexno() < startUnit) {
                startUnit = unit.getIndexno();
            }
            if (unit.getIndexno() <= endUnit) continue;
            endUnit = unit.getIndexno();
        }
        return Pair.of((Object)startUnit, (Object)endUnit);
    }

    public List<CourseUnit> getUnits() {
        return this.units;
    }

    public void setUnits(List<CourseUnit> units) {
        this.units = units;
    }

    public short getMinutesPerUnit() {
        return this.minutesPerUnit;
    }

    public void setMinutesPerUnit(short minutesPerUnit) {
        this.minutesPerUnit = minutesPerUnit;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }
}

