/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Department;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.base.model.User;
import org.openurp.code.hr.model.WorkStatus;
import org.openurp.code.job.model.ProfessionalGrade;
import org.openurp.code.job.model.ProfessionalTitle;
import org.openurp.edu.base.code.model.TeacherType;
import org.openurp.edu.base.model.Project;

@Entity(name="org.openurp.edu.base.model.Teacher")
@Cacheable
@Cache(region="eams.core", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Teacher
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = 1L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected User user;
    @ManyToOne(fetch=FetchType.LAZY)
    protected ProfessionalTitle title;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected TeacherType teacherType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private WorkStatus status;
    @NotNull
    private Date beginOn;
    private Date endOn;
    @Size(max=500)
    protected String remark;

    public String getCode() {
        return null == this.user ? null : this.user.getCode();
    }

    public String getName() {
        return null == this.user ? null : this.user.getName();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Department getDepartment() {
        return null == this.user ? null : this.user.getDepartment();
    }

    public TeacherType getTeacherType() {
        return this.teacherType;
    }

    public void setTeacherType(TeacherType teacherType) {
        this.teacherType = teacherType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Teacher() {
    }

    public Teacher(Long id) {
        this.setId(id);
    }

    public ProfessionalTitle getTitle() {
        return this.title;
    }

    public void setTitle(ProfessionalTitle title) {
        this.title = title;
    }

    public ProfessionalGrade getTitleGrade() {
        return null == this.title ? null : this.title.getGrade();
    }

    public WorkStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkStatus status) {
        this.status = status;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

