/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.NumberIdObject;
import org.beangle.commons.lang.time.HourMinute;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.code.edu.model.DayPart;
import org.openurp.edu.base.model.TimeSetting;

@Entity(name="org.openurp.edu.base.model.CourseUnit")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class CourseUnit
extends NumberIdObject<Integer>
implements Cloneable,
Comparable<CourseUnit> {
    private static final long serialVersionUID = -3452158480415380931L;
    @NotNull
    private int indexno;
    @NotNull
    @Size(max=20)
    private String name;
    @NotNull
    @Size(max=50)
    private String enName;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private DayPart part;
    @NotNull
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute beginAt;
    @NotNull
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute endAt;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private TimeSetting setting;

    public DayPart getPart() {
        return this.part;
    }

    public void setPart(DayPart part) {
        this.part = part;
    }

    public CourseUnit() {
    }

    public CourseUnit(HourMinute beginAt, HourMinute endAt) {
        this.beginAt = beginAt;
        this.endAt = endAt;
    }

    public CourseUnit(int index, HourMinute beginAt, HourMinute endAt) {
        this.indexno = index;
        this.beginAt = beginAt;
        this.endAt = endAt;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endTime) {
        this.endAt = endTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public TimeSetting getSetting() {
        return this.setting;
    }

    public void setSetting(TimeSetting setting) {
        this.setting = setting;
    }

    public int getIndexno() {
        return this.indexno;
    }

    public void setIndexno(int index) {
        this.indexno = index;
    }

    @Override
    public int compareTo(CourseUnit other) {
        return this.getIndexno() - other.getIndexno();
    }

    public String getColor() {
        return this.part.getColor();
    }

    public boolean overlapWith(HourMinute beginAt, HourMinute endAt) {
        return CourseUnit.isCrossWith(this, new CourseUnit(beginAt, endAt));
    }

    public static boolean isCrossWith(CourseUnit me, CourseUnit unit) {
        return unit.getEndAt().gt(me.getBeginAt()) && me.getEndAt().gt(unit.getBeginAt());
    }
}

