/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import org.beangle.commons.collection.Collections
import org.beangle.data.model.{ Coded, LongIdEntity, Named, TemporalOn, Updated }
import org.openurp.base.{ Department, User }
import org.openurp.edu.base.code.StdType

/**
 * 行政班级信息
 * </p>
 * 行政班级为学校为了行政管理需要建立的基层组织单位。行政班级可以设定年级、部门、专业、方向，以及计划人数。
 * 但是不强制班级内的学生都来自统一个专业和方向,因此班级中的专业、方向等可以为空。这种情况可以通过学生标签
 * 进行标识。
 * </p>
 * 计划人数为班级创建时编制的，主要用于估计新生的规模。班级的人数是指班级内所有学生的数量，没有单独设立
 * 在籍人数、在校人数,这些可以通过给定的时间根据每位学生当时是否在籍或在校而计算获得。
 * 班级也是有时效行的实体之一，通过班级的年级和学制确定有效日期和失效日期
 * </p>
 * 一般设立一个到多个辅导员。
 *
 * @composed 1 has * Student
 * @opt operations
 * @depend - - - Department
 * @depend - - - Major
 * @depend - - - Direction
 * @author chaostone
 * @author 鄂州蚊子
 * @since 2008-10-27
 * @since 3.0.0
 */

trait Adminclass extends LongIdEntity with EducationBased with Coded with Named with TemporalOn with Updated {

  /** 年级,形式为yyyy-p */
  var grade: String = _
  /** 简称 */
  var abbreviation: String = _
  /** 备注*/
  var remark: String = _

  /** 院系 */
  var department: Department = _
  /** 专业 */
  var major: Major = _
  /** 方向 */
  var direction: Direction = _
  /** 学生类别 */
  var stdType: StdType = _
  /** 计划人数 */
  var planCount: Int = _
  /** 学籍有效人数 */
  var stdCount: Int = _
  /** 辅导员 */
  var instructors = Collections.newBuffer[User]
  /** 班导师 */
  var tutors = Collections.newBuffer[User]
  /** 学生列表 班级学生 */
  var students = Collections.newBuffer[Student]

}



