/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import java.sql.Date

import org.beangle.data.model.{ Coded, Entity, LongIdEntity, Named, Updated }
import org.openurp.base.Department
import org.openurp.code.edu.Education
import org.openurp.edu.base.code.{ CourseAbilityRate, CourseCategory, CourseHourType, CourseType, ExamMode, ScoreMarkStyle }

/**
 * 课程基本信息 </p>
 * 记录课程代码、名称、学分、课时等基本信息，课程的关键业务属性为课程名称、学分、课时、考核方式等与课程有关的属性，其它类似课程类别、所属部门等
 * 均可以看作非关键属性。 </p> 如课程不要求记录学分、不做考核要求、不计算绩点等额外要求需要培养方案、成绩等环节进行额外处理，不在课程部分进行规定。
 * <p>
 * 课程的学历层次可以不加指定，为空时表示适用与对应项目下的所有学历层次。
 *
 * @depend - - - CourseCategory
 * @depend - - - Department
 * @depend - - - CourseType
 * @depeimport org.openurp.edu.teach.Major
 * import org.openurp.edu.teach.ExamGrade
 * import org.openurp.edu.teach.Student
 * nd - - - ExamMode
 * @author cheneystar
 * @author chaostone
 * @since 2008-09-24
 */
trait Course extends LongIdEntity with ProjectBased with Ordered[Course] with Updated with Coded with Named {
  /**课程英文名*/
  var enName: String = _
  /** 学历层次 */
  var education: Education = _
  /**课程种类代码*/
  var category: CourseCategory = _
  /**学分*/
  var credits: java.lang.Float = _
  /** 学时/总课时 */
  var period: Integer = _
  /**课程类型*/
  var courseType: CourseType = _
  /** 分类课时 */
  var hours: collection.mutable.Seq[CourseHour] = new collection.mutable.ListBuffer[CourseHour]
  /** 周数*/
  var weeks: Integer = _
  /**周课时*/
  var weekHour: Integer = _
  /**院系*/
  var department: Department = _
  /** 设立时间 */
  var establishOn: Date = _
  /** 考试方式 */
  var examMode: ExamMode = _
  /** 成绩记录方式 */
  var markStyle: ScoreMarkStyle = _

  /** 能力等级 */
  var abilityRates: collection.mutable.Set[CourseAbilityRate] = new collection.mutable.HashSet[CourseAbilityRate]
  /**针对专业*/
  var majors: collection.mutable.Set[Major] = new collection.mutable.HashSet[Major]
  /**排除专业*/
  var xmajors: collection.mutable.Set[Major] = new collection.mutable.HashSet[Major]
  /**先修课程*/
  var prerequisites: collection.mutable.Set[Course] = new collection.mutable.HashSet[Course]

  var textbooks: collection.mutable.Set[Textbook] = new collection.mutable.HashSet[Textbook]

  var teachers: collection.mutable.Set[Teacher] = new collection.mutable.HashSet[Teacher]
  /**课程使用状态*/
  var enabled: Boolean = _
  /**课程备注*/
  var remark: String = _
  /** 是否计算绩点 **/
  var calGp: Boolean = _

  override def compare(other: Course): Int = {
    code.compareTo(other.code)
  }
}

trait CourseHour extends Entity[java.lang.Long] {
  var course: Course = _
  var period: Integer = _
  var weekHour: Integer = _
  var weeks: Integer = _
  var hourType: CourseHourType = _
}