/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import org.openurp.base.Department
import org.beangle.data.model.TemporalOn
import org.beangle.data.model.Entity
import org.openurp.code.edu.Education
import scala.collection.mutable.Buffer
import org.beangle.data.model.Named
import org.beangle.data.model.Coded

trait Direction extends Entity[java.lang.Long] with TemporalOn  with Coded with Named {
  /** 专业方向英文名 */
  var enName: String = _
  /** 备注 */
  var remark: String = _
  /** 所属专业 */
  var major: Major = _
  /** 部门 */
  var journals: Buffer[DirectionJournal] = new collection.mutable.ListBuffer[DirectionJournal]
}
/**
 * 方向和部门对应关系
 * @author chaostone
 *
 */
trait DirectionJournal extends Entity[java.lang.Long] with TemporalOn {

  /**专业方向*/
  var direction: Direction = _
  /**培养层次*/
  var education: Education = _
  /**部门*/
  var depart: Department = _
  /**备注*/
  var remark: String = _
}
