/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import org.beangle.data.model.{ LongIdEntity, Named, TemporalOn, Updated }
import org.openurp.base.Department
import org.openurp.code.edu.{ Degree, Education, StudyType }
import org.openurp.edu.base.code.StdType

trait Program extends LongIdEntity with Updated with Named with Cloneable with TemporalOn {

  /**
   * 年级
   */
  var grade: String = _

  /**
   * 部门
   */
  var department: Department = _

  /**
   * 培养层次
   */
  var education: Education = _

  /**
   * 学生类别
   */
  var stdType: StdType = _

  /**
   * 专业
   */
  var major: Major = _

  /**
   * 专业方向
   */
  var direction: Direction = _

  /**
   * 学制
   */
  var duration: Float = _

  /**
   * 学习形式
   */
  var studyType: StudyType = _

  /**
   * 毕业授予学位
   */
  var degree: Degree = _

  /**
   * 备注
   */
  var remark: String = _

  /**
   * 审核状态
   */
  var state: States.State = States.Draft
}
