/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import scala.collection.mutable.{ Buffer, ListBuffer }
import org.beangle.data.model.{ Coded, Entity, Named, TemporalOn }
import org.beangle.data.model.bean.NumIdBean
import org.openurp.base.{ Calendar, Campus, Department, Room, School, TimeSetting }
import org.openurp.code.edu.Education
import org.openurp.edu.base.code.{ StdLabel, StdType }
import org.beangle.data.model.bean.LongIdBean
import org.beangle.data.model.LongIdEntity

/**
 * 教学项目
 * </p>
 * 教学项目是指本科教学、研究生教学、辅修教学等教学项目。项目本身主要用于管理学校具备独立运作、具备较强隔离性的教学项目。
 * 他是按照EAMS核心业务范围建立的顶级概念。
 * 项目可以简要描述为：在1）固定的部门和授课团队等师资下，培养2）固定学历层次的学生，培养学生可以按照分类标签进行划分；
 * 具体培养过程中可以使用3）固定的校区和稳定的教学校历，这种过程和资源的总称为项目。
 *
 * @author chaostone
 * @since 3.0.0
 */
trait Project extends Entity[Integer] with Coded with TemporalOn with Named {
  /** 适用学校 */
  var school: School = _
  /** 校区列表 */
  var campuses: Buffer[Campus] = new ListBuffer[Campus]
  /** 部门列表 */
  var departments: Buffer[Department] = new ListBuffer[Department]
  /** 学历层次列表 */
  var educations: Buffer[Education] = new ListBuffer[Education]
  /** 学生分类列表 */
  var labels: Buffer[StdLabel] = new ListBuffer[StdLabel]

  var stdTypes: Buffer[StdType] = new ListBuffer[StdType]

  /** 使用校历 */
  var calendar: Calendar = _
  /** 小节设置 */
  var timeSettings: Buffer[TimeSetting] = new ListBuffer[TimeSetting]
  /** 描述 */
  var description: String = _
  /** 是否辅修 */
  var minor: Boolean = _

  var properties: collection.mutable.Map[String, String] = new collection.mutable.HashMap[String, String]

}
/**
 * 基于项目的业务实体接口
 *
 * @author chaostone
 * @since 3.0.0
 */
trait ProjectBased {

  var project: Project = _
}

/**
 * 项目教室关系数据
 *
 * @author chaostone
 */

trait ProjectClassroom extends LongIdEntity with ProjectBased {
  /** 教室 */
  var room: Room = _
  /** 固定使用部门 */
  var departs: collection.mutable.Set[Department] = new collection.mutable.HashSet[Department]
  /** 保留时间 */
  //  var reserved:List[TimeUnit]=_
} 