/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base

import org.beangle.data.model.TemporalOn
import org.openurp.base.User
import org.openurp.hr.base.Staff
import org.beangle.data.model.LongIdEntity
import org.beangle.commons.collection.Collections

/**
 * 教师信息
 * @depend - - - org.openurp.teach.core.ProjectBasedEntity
 * @author chaostone
 * @since 2005
 */

trait Teacher extends LongIdEntity with TemporalOn {

  /**人员信息*/
  var staff: Staff = _

  /**所任项目*/
  var projects = Collections.newBuffer[Project]

  var remark: String = _
}
