/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.code.model

import org.beangle.data.model.annotation.code
import org.openurp.code.BaseCodeBean
import org.openurp.edu.base.code._

/**
 * 学生分类标签
 *
 * @author chaostone
 * @since 3.0.0
 */
class StdLabelBean extends BaseCodeBean with StdLabel
/**
 * 学生分类标签类型
 *
 * @author chaostone
 * @since 3.0.0
 */

class StdLabelTypeBean extends BaseCodeBean with StdLabelType

/**
 * 学生类别
 *
 * @author chaostone
 * @since 3.0.0
 */
class StdTypeBean extends BaseCodeBean with StdType

/**
 * 学生学籍状态
 *
 * @author chaostone
 * @since 2005-9-7
 */
class StdStatusBean extends BaseCodeBean with StdStatus 

/**
 * 成绩记录方式
 */
class ScoreMarkStyleBean extends BaseCodeBean with ScoreMarkStyle{
  def this(id: Integer) {
    this()
    this.id = id
  }
  def this(id: Integer, code: String, name: String, enName: String) {
    this()
    this.id = id
    this.code = code
    this.name = name
    this.enName = enName
  }
}


/**
 * 考试情况
 * 正常、作弊、旷考等
 *
 * @author chaostone
 * @since 2005-9-7
 */
class ExamStatusBean extends BaseCodeBean with ExamStatus {
  def this(id: Integer) {
    this()
    this.id = id
  }
}


/**
 * 课程类别
 *
 * @author chaostone
 * @since 2005-9-7
 */
class CourseTypeBean extends BaseCodeBean with CourseType {

  def this(id: Integer, code: String, name: String, enName: String) {
    this()
    this.id = id
    this.code = code
    this.name = name
    this.enName = enName
  }
}

/**
 * 课程种类
 * （一般、体育、挂牌、双语）
 *
 * @author chaostone
 * @since 2005-11-17
 */
class CourseCategoryBean extends BaseCodeBean with CourseCategory
/**
 * 考核方式
 *
 * @author chaostone
 * @since 2005-9-7
 */
class ExamModeBean extends BaseCodeBean with ExamMode

/**
 * 课时类别代码
 */
class CourseHourTypeBean extends BaseCodeBean with CourseHourType 

/**
 * 课程能力等级
 */
class CourseAbilityRateBean extends BaseCodeBean with CourseAbilityRate

/**
 * 教材类型
 */
@code("school")
trait BookTypeBean extends BaseCodeBean with BookType

/**
 * 教材获奖类型
 */
@code("school")
trait BookAwardTypeBean extends BaseCodeBean with BookAwardType
