/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.code

import org.openurp.code.BaseCode
import org.beangle.data.model.annotation.code

/**
 * 学生分类标签
 *
 * @author chaostone
 * @since 3.0.0
 */
@code("school")
trait StdLabel extends BaseCode {

  var labelType: StdLabelType = _
}
/**
 * 学生分类标签类型
 *
 * @author chaostone
 * @since 3.0.0
 */
@code("school")
trait StdLabelType extends BaseCode {

}

/**
 * 学生类别
 *
 * @author chaostone
 * @since 3.0.0
 */
@code("school")
trait StdType extends BaseCode
/**
 * 学生学籍状态
 *
 * @author chaostone
 * @since 3.0.0
 */
@code("school")
trait StdStatus extends BaseCode {

}

/**
 * 成绩记录方式
 *
 * @author chaostone
 */
@code("school")
trait ScoreMarkStyle extends BaseCode  {

  var numStyle: Boolean = _
}
object ScoreMarkStyle {
  val Percent = Integer.valueOf(1)
}


object ExamStatus {

  /** 正常 */
  val Normal = 1;

  /** 缓考 */
  val Delay = 2;

  /** 旷缺 */
  val Absent = 3;

  /** 违纪 */
  val Violation = 4;

  /** 作弊 */
  val Cheat = 5;

  /**无考试资格*/
  val Unqualify = 6;

  /**其他*/
  val Misc = 9;
}
/**
 * 考试情况
 * 正常、作弊、旷考等
 */
@code("school")
trait ExamStatus extends BaseCode{
  /**
   * 是否参加考试
   */
  var attend: Boolean = _
  /**
   * 是否需要参加下一次缓考
   * @return
   */
  var needAttendDelay: Boolean = _
  /**
   * 能否录入成绩
   * @return
   */
  var inputable: Boolean = _
}
/**
 * 考核方式
 */
@code("school")
trait ExamMode extends BaseCode


/**
 * 课程类别
 *
 * @author chaostone
 */
@code("school")
trait CourseType extends BaseCode {
  var theoretical: Boolean = _
}

/**
 * 课程种类
 * （一般、体育、挂牌、双语）
 *
 * @author chaostone
 */
@code("school")
trait CourseCategory extends BaseCode

/**
 * 课时类别代码
 *
 * @author chaostone
 */
@code("school")
trait CourseHourType extends BaseCode

/**
 * 课程能力等级
 * @author chaostone
 */
@code("school")
trait CourseAbilityRate extends BaseCode


/**
 * 教材类型
 */
@code("school")
trait BookType extends BaseCode

/**
 * 教材获奖类型
 */
@code("school")
trait BookAwardType extends BaseCode


