/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.model

import org.beangle.data.model.bean.LongIdBean
import org.openurp.edu.base.{ Adminclass, Program, Teacher, Textbook }

/**
 * 学生行政班级信息
 *
 * @author chaostone
 * @since 2005-9-12
 */
class AdminclassBean extends LongIdBean with Adminclass

/**
 * 专业培养方案
 * @author chaostone
 *
 */
class ProgramBean extends LongIdBean with Program

/**
 * 教师信息默认实现
 */
class TeacherBean extends LongIdBean with Teacher

class TextbookBean extends LongIdBean with Textbook 

