/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.model

import org.beangle.data.model.bean.{IntIdBean, LongIdBean}
import org.openurp.base.code.model.CodeMeta
import org.openurp.edu.base.{Project, ProjectClassroom}
/**
 * 项目
 *
 * @has 1..* AssignedTo 1..* Department
 * @has 1..* AssignedTo 1..* Education
 * @has 1..* AssignedTo 1..* StudentType
 * @has 1..* AssignedTo 1..* StdLabel
 * @depend - - - Calendar
 */
class ProjectBean extends IntIdBean with Project
/**
 * 项目基础代码配置
 * 表示项目使用了基础代码集合中的哪些基础代码
 *
 * @author chaostone
 */
class ProjectCodeBean extends LongIdBean {
  /**项目*/
  var project: Project = _
  /**代码元*/
  var meta: CodeMeta = _
  /**代码ID*/
  var codeId: Integer = _
}

/**
 * 项目教室配置
 * @author chaostone
 *
 */
class ProjectClassroomBean extends LongIdBean with ProjectClassroom 

