/*
 * OpenURP, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2014-2015, OpenURP Software.
 *
 * OpenURP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OpenURP is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenURP.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.openurp.edu.base.model

import org.beangle.data.model.Component
import org.beangle.data.model.annotation.code
import org.beangle.data.model.bean.LongIdBean
import org.openurp.base.Department
import org.openurp.code.edu.Education
import org.openurp.edu.base.{Direction, Major, Project, Student, StudentJournal}
import org.openurp.edu.base.code.StdType

/**
 * 学籍信息实现
 */
class StudentBean extends LongIdBean with Student
/**
 * 学籍状态日志
 */

class StudentJournalBean extends LongIdBean with StudentJournal

/**
 * 学生范围
 *
 * @author qianjia
 */
class StudentScope extends Component {
  /**年级*/
  var grades: String = _
  /**项目*/
  var project: Project = _
  /**培养层次集合*/
  var educations: collection.mutable.Set[Education] = _
  /**学生类别集合*/
  var stdTypes: collection.mutable.Set[StdType] = _
  /**部门集合*/
  var departments: collection.mutable.Set[Department] = _
  /**专业集合*/
  var majors: collection.mutable.Set[Major] = _
  /**专业方向集合*/
  var directions: collection.mutable.Set[Direction] = _

}
