/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.web;

import com.google.gson.Gson;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.security.Securities$;
import org.beangle.security.authc.DefaultAccount;
import org.beangle.security.session.Session;
import org.openurp.app.web.URPProfile;
import org.openurp.app.web.URPProfile$;
import org.openurp.base.model.School;
import org.openurp.edu.base.model.Project;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003E\u0001\u0011\u0005Q\tC\u0003N\u0001\u0011%a\nC\u0003U\u0001\u0011%QK\u0001\tV%B\u0003&o\u001c4jY\u0016DU\r\u001c9fe*\u0011\u0011BC\u0001\u0004o\u0016\u0014'BA\u0006\r\u0003\u0011\u0011\u0017m]3\u000b\u00055q\u0011aA3ek*\u0011q\u0002E\u0001\b_B,g.\u001e:q\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u0006IQM\u001c;jif$\u0015m\u001c\t\u00039\rj\u0011!\b\u0006\u0003=}\t1\u0001Z1p\u0015\t\u0001\u0013%\u0001\u0003eCR\f'B\u0001\u0012\u0011\u0003\u001d\u0011W-\u00198hY\u0016L!\u0001J\u000f\u0003\u0013\u0015sG/\u001b;z\t\u0006|\u0017A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0011!)!D\u0001a\u00017\u0005Iq-\u001a;TG\"|w\u000e\u001c\u000b\u0004YMz\u0004CA\u00172\u001b\u0005q#BA\u00181\u0003\u0015iw\u000eZ3m\u0015\tYa\"\u0003\u00023]\t11k\u00195p_2DQ\u0001N\u0002A\u0002U\n1A]3r!\t1T(D\u00018\u0015\tA\u0014(\u0001\u0003iiR\u0004(B\u0001\u001e<\u0003\u001d\u0019XM\u001d<mKRT\u0011\u0001P\u0001\u0006U\u00064\u0018\r_\u0005\u0003}]\u0012!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\")\u0001i\u0001a\u0001\u0003\u0006\u0019!/Z:\u0011\u0005Y\u0012\u0015BA\"8\u0005MAE\u000f\u001e9TKJ4H.\u001a;SKN\u0004xN\\:f\u0003)9W\r\u001e)s_*,7\r\u001e\u000b\u0004\r.c\u0005CA$J\u001b\u0005A%BA\u0018\u000b\u0013\tQ\u0005JA\u0004Qe>TWm\u0019;\t\u000bQ\"\u0001\u0019A\u001b\t\u000b\u0001#\u0001\u0019A!\u0002-\u0019Lg\u000eZ*dQ>|GNQ=TKJ4XM\u001d(b[\u0016$\"a\u0014*\u0011\u0007U\u0001F&\u0003\u0002R-\t1q\n\u001d;j_:DQaU\u0003A\u0002U\nqA]3rk\u0016\u001cH/A\bhKR4\u0015N]:u!J|'.Z2u)\u00051\u0005")
public class URPProfileHelper {
    private final EntityDao entityDao;

    public School getSchool(HttpServletRequest req, HttpServletResponse res) {
        School school;
        Option<School> option = this.findSchoolByServerName(req);
        if (option instanceof Some) {
            School s;
            Some some = (Some)option;
            school = s = (School)some.value();
        } else if (None$.MODULE$.equals(option)) {
            ObjectRef school2 = ObjectRef.create(null);
            URPProfile profile = URPProfile$.MODULE$.get(req, res);
            if (profile.hasValidProject()) {
                Project project = (Project)this.entityDao.get(Project.class, (Object)BoxesRunTime.boxToInteger((int)profile.edu().projectId()));
                school2.elem = project.school();
                if (profile.schoolId() != BoxesRunTime.unboxToInt((Object)((School)school2.elem).id())) {
                    profile.schoolId_$eq(BoxesRunTime.unboxToInt((Object)((School)school2.elem).id()));
                    URPProfile$.MODULE$.update(req, res, profile, true);
                }
            }
            if ((School)school2.elem == null) {
                Securities$.MODULE$.session().foreach((Function1 & Serializable)session -> {
                    URPProfileHelper.$anonfun$getSchool$1(this, profile, school2, req, res, session);
                    return BoxedUnit.UNIT;
                });
            }
            if ((School)school2.elem == null) {
                school2.elem = (School)this.entityDao.getAll(School.class).head();
                profile.schoolId_$eq(BoxesRunTime.unboxToInt((Object)((School)school2.elem).id()));
                school2.elem = (School)school2.elem;
                URPProfile$.MODULE$.update(req, res, profile, true);
            }
            school = (School)school2.elem;
        } else {
            throw new MatchError(option);
        }
        return school;
    }

    public Project getProject(HttpServletRequest req, HttpServletResponse res) {
        ObjectRef project;
        block2: {
            project = ObjectRef.create(null);
            URPProfile profile = URPProfile$.MODULE$.get(req, res);
            if (profile.hasValidProject()) {
                project.elem = (Project)this.entityDao.get(Project.class, (Object)BoxesRunTime.boxToInteger((int)profile.edu().projectId()));
            }
            if ((Project)project.elem == null) {
                Securities$.MODULE$.session().foreach((Function1 & Serializable)session -> {
                    URPProfileHelper.$anonfun$getProject$1(this, project, profile, req, res, session);
                    return BoxedUnit.UNIT;
                });
            }
            if ((Project)project.elem != null) break block2;
            project.elem = this.getFirstProject();
        }
        return (Project)project.elem;
    }

    private Option<School> findSchoolByServerName(HttpServletRequest request) {
        OqlBuilder qual$1 = (OqlBuilder)OqlBuilder$.MODULE$.from(School.class, "p").where("p.code =:pcode", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{request.getServerName()}));
        boolean x$1 = qual$1.cacheable$default$1();
        OqlBuilder builder = (OqlBuilder)qual$1.cacheable(x$1);
        return this.entityDao.search((QueryBuilder)builder).headOption();
    }

    private Project getFirstProject() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(Project.class, "p");
        query.where("p.endOn is null or p.endOn > :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        OqlBuilder qual$1 = (OqlBuilder)query.orderBy("p.code");
        boolean x$1 = qual$1.cacheable$default$1();
        qual$1.cacheable(x$1);
        return (Project)this.entityDao.search((QueryBuilder)query).head();
    }

    public static final /* synthetic */ void $anonfun$getSchool$1(URPProfileHelper $this, URPProfile profile$1, ObjectRef school$1, HttpServletRequest req$1, HttpServletResponse res$1, Session session) {
        DefaultAccount account = (DefaultAccount)session.principal();
        String profileStr = (String)account.details().get((Object)"profiles_edu");
        if (Strings$.MODULE$.isNotBlank((CharSequence)profileStr)) {
            Iterator profileIter = ((List)new Gson().fromJson(profileStr, List.class)).iterator();
            boolean finded = false;
            Project project = null;
            while (profileIter.hasNext() && !finded) {
                String pstr = (String)((Map)profileIter.next()).get("projects");
                if (pstr == null) continue;
                String string = pstr;
                String string2 = "*";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    project = $this.getFirstProject();
                } else if (Numbers$.MODULE$.isDigits(pstr)) {
                    project = (Project)$this.entityDao.get(Project.class, (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pstr))));
                }
                if (project == null) continue;
                finded = true;
                profile$1.updateProject(BoxesRunTime.unboxToInt((Object)project.id()));
                profile$1.schoolId_$eq(BoxesRunTime.unboxToInt((Object)project.school().id()));
                school$1.elem = project.school();
                URPProfile$.MODULE$.update(req$1, res$1, profile$1, true);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getProject$2(URPProfileHelper $this, ObjectRef project$1, URPProfile profile$2, HttpServletRequest req$2, HttpServletResponse res$2, String profileStr) {
        Iterator profileIter = ((List)new Gson().fromJson(profileStr, List.class)).iterator();
        boolean finded = false;
        while (profileIter.hasNext() && !finded) {
            String pstr = (String)((Map)profileIter.next()).get("projects");
            if (pstr == null) continue;
            String string = pstr;
            String string2 = "*";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                project$1.elem = $this.getFirstProject();
            } else if (Numbers$.MODULE$.isDigits(pstr)) {
                project$1.elem = (Project)$this.entityDao.get(Project.class, (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(pstr))));
            }
            if ((Project)project$1.elem == null) continue;
            finded = true;
            profile$2.updateProject(BoxesRunTime.unboxToInt((Object)((Project)project$1.elem).id()));
            URPProfile$.MODULE$.update(req$2, res$2, profile$2, true);
        }
    }

    public static final /* synthetic */ void $anonfun$getProject$1(URPProfileHelper $this, ObjectRef project$1, URPProfile profile$2, HttpServletRequest req$2, HttpServletResponse res$2, Session session) {
        DefaultAccount account = (DefaultAccount)session.principal();
        account.details().get((Object)"profiles_edu").foreach((Function1 & Serializable)profileStr -> {
            URPProfileHelper.$anonfun$getProject$2($this, project$1, profile$2, req$2, res$2, profileStr);
            return BoxedUnit.UNIT;
        });
    }

    public URPProfileHelper(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

