/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.edu.base.code.model.ExamStatus;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.course.model.Clazz;
import org.openurp.edu.course.model.CourseTaker;

@Entity(name="org.openurp.edu.course.model.ExamTaker")
public class ExamTaker
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -1593583921052845498L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType = new ExamType();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamStatus examStatus = new ExamStatus();
    @Size(max=255)
    private String remark;

    public ExamTaker() {
    }

    public ExamTaker(CourseTaker taker, ExamType examType) {
        this.examStatus = new ExamStatus(ExamStatus.NORMAL);
        this.examType = examType;
        this.setStd(taker.getStd());
        this.clazz = taker.getClazz();
    }

    public ExamStatus getExamStatus() {
        return this.examStatus;
    }

    public void setExamStatus(ExamStatus examStatus) {
        this.examStatus = examStatus;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Object clone() {
        try {
            ExamTaker taker = (ExamTaker)super.clone();
            taker.setId(null);
            taker.setClazz(null);
            return taker;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

