/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.ProjectBasedObject;
import org.openurp.edu.base.model.Squad;
import org.openurp.edu.course.model.Clazz;

@Entity(name="org.openurp.edu.course.model.ClazzGroup")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class ClazzGroup
extends ProjectBasedObject<Long> {
    private static final long serialVersionUID = 2894364425087924997L;
    @Size(max=255)
    @NotNull
    private String name;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department teachDepart;
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @Size(max=20)
    private String grade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @OneToMany(mappedBy="group")
    private Set<Clazz> clazzes = CollectUtils.newHashSet();
    @ManyToMany
    private Set<Squad> squads = CollectUtils.newHashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Clazz> getClazzes() {
        return this.clazzes;
    }

    public void setClazzes(Set<Clazz> clazzes) {
        this.clazzes = clazzes;
    }

    public boolean addClazz(Clazz clazz) {
        return null != clazz && this.clazzes.add(clazz);
    }

    public boolean removeClazz(Clazz clazz) {
        return null != clazz && this.clazzes.remove(clazz);
    }

    public void clearClazz() {
        this.clazzes.clear();
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Department getTeachDepart() {
        return this.teachDepart;
    }

    public void setTeachDepart(Department teachDepart) {
        this.teachDepart = teachDepart;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public Set<Squad> getSquads() {
        return this.squads;
    }

    public void setSquads(Set<Squad> classes) {
        this.squads = classes;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }
}

