/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.base.model.Department;
import org.openurp.edu.base.code.model.CourseAbilityRate;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.course.model.Clazz;
import org.openurp.edu.course.model.CourseTaker;
import org.openurp.edu.course.model.ExamTaker;
import org.openurp.edu.course.model.Restriction;
import org.openurp.edu.course.util.GenderRatio;

@Embeddable
public class Enrollment
implements Component,
Cloneable,
Serializable {
    private static final long serialVersionUID = 895173901324223302L;
    private String grade;
    @NotNull
    @Type(type="org.beangle.data.jpa.hibernate.udt.GenderRatioType")
    private GenderRatio genderRatio = GenderRatio.empty;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department depart;
    @NotNull
    private int actual;
    private int capacity;
    private boolean locked;
    private int reserved;
    @OneToMany(mappedBy="clazz", cascade={CascadeType.ALL})
    private Set<CourseTaker> courseTakers = new HashSet<CourseTaker>();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private List<CourseAbilityRate> abilityRates = new ArrayList<CourseAbilityRate>();
    @OneToMany(mappedBy="clazz", cascade={CascadeType.ALL})
    private Set<ExamTaker> examTakers = new HashSet<ExamTaker>();
    @OneToMany(mappedBy="clazz", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    @OrderBy(value="id")
    private List<Restriction> restrictions = CollectUtils.newArrayList();

    public List<ExamTaker> getExamTakers(ExamType examType) {
        if (CollectUtils.isEmpty(this.getExamTakers())) {
            return Collections.emptyList();
        }
        List rs = CollectUtils.newArrayList();
        for (ExamTaker taker : this.getExamTakers()) {
            if (!examType.equals((Object)taker.getExamType())) continue;
            rs.add(taker);
        }
        return rs;
    }

    public int calcExamCount(ExamType examType) {
        return this.getExamTakers(examType).size();
    }

    public Enrollment clone() {
        try {
            Enrollment clone = (Enrollment)super.clone();
            clone.setRestrictions(new ArrayList<Restriction>());
            for (Restriction group : this.getRestrictions()) {
                Restriction clone_group = (Restriction)group.clone();
                clone.getRestrictions().add(clone_group);
            }
            clone.setCourseTakers(new HashSet<CourseTaker>());
            for (CourseTaker taker : this.getCourseTakers()) {
                CourseTaker clone_taker = (CourseTaker)taker.clone();
                clone.getCourseTakers().add(clone_taker);
            }
            clone.setAbilityRates(new ArrayList<CourseAbilityRate>(this.getAbilityRates()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public CourseTaker getCourseTaker(Long stdId) {
        for (CourseTaker taker : this.getCourseTakers()) {
            if (!((Long)taker.getStd().getId()).equals(stdId)) continue;
            return taker;
        }
        return null;
    }

    public Set<CourseTaker> getNormalCourseTakers() {
        Set normalTakers = CollectUtils.newHashSet();
        if (CollectUtils.isNotEmpty(this.courseTakers)) {
            for (CourseTaker courseTaker : this.courseTakers) {
                if (courseTaker.isFreeListening()) continue;
                normalTakers.add(courseTaker);
            }
        }
        return normalTakers;
    }

    public void addLimitGroups(Clazz clazz, List<Restriction> groups) {
        for (Restriction group : groups) {
            group.setClazz(clazz);
            this.restrictions.add(group);
        }
    }

    public void addLimitGroups(Clazz clazz, Restriction ... groups) {
        Restriction[] restrictionArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Restriction group = restrictionArray[n2];
            group.setClazz(clazz);
            this.restrictions.add(group);
            ++n2;
        }
    }

    public Restriction getOrCreateDefautRestriction() {
        for (Restriction limitGroup : this.restrictions) {
            if (!limitGroup.isPrime()) continue;
            return limitGroup;
        }
        Restriction forClassGroup = new Restriction();
        forClassGroup.setPrime(true);
        this.getRestrictions().add(forClassGroup);
        return forClassGroup;
    }

    public CourseTaker getCourseTaker(Student std) {
        return this.getCourseTaker((Long)std.getId());
    }

    public int getActual() {
        return this.actual;
    }

    public void setActual(int stdCount) {
        this.actual = stdCount;
    }

    public Set<CourseTaker> getCourseTakers() {
        return this.courseTakers;
    }

    public void setCourseTakers(Set<CourseTaker> courseTakers) {
        this.courseTakers = courseTakers;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int limitCount) {
        this.capacity = limitCount;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String year) {
        this.grade = year;
    }

    public Department getDepart() {
        return this.depart;
    }

    public void setDepart(Department depart) {
        this.depart = depart;
    }

    public Set<ExamTaker> getExamTakers() {
        return this.examTakers;
    }

    public void setExamTakers(Set<ExamTaker> examTakers) {
        this.examTakers = examTakers;
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<Restriction> limitGroups) {
        this.restrictions = limitGroups;
    }

    public GenderRatio getGenderRatio() {
        return this.genderRatio;
    }

    public void setGenderRatio(GenderRatio genderRatio) {
        this.genderRatio = genderRatio;
    }

    public List<CourseAbilityRate> getAbilityRates() {
        return this.abilityRates;
    }

    public void setAbilityRates(List<CourseAbilityRate> abilityRates) {
        this.abilityRates = abilityRates;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }
}

