/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.Component;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.time.WeekState;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.openurp.code.edu.model.ClassroomType;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.course.model.Session;

@Embeddable
public class Schedule
implements Serializable,
Cloneable,
Component {
    private static final long serialVersionUID = 3067092503219100019L;
    @NotNull
    private int period;
    @NotNull
    @Type(type="org.beangle.commons.lang.time.hibernate.WeekStateType")
    private WeekState weekstate = WeekState.Zero;
    @OneToMany(mappedBy="clazz", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Session> sessions = new HashSet<Session>();
    @ManyToOne(fetch=FetchType.LAZY)
    private ClassroomType roomType;

    public Schedule clone() {
        try {
            Schedule info = (Schedule)super.clone();
            info.setSessions(new HashSet<Session>());
            return info;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Classroom> getRooms() {
        if (this.getSessions() != null && !this.getSessions().isEmpty()) {
            HashSet<Classroom> rooms = new HashSet<Classroom>();
            for (Session session : this.getSessions()) {
                rooms.addAll(session.getRooms());
            }
            return rooms;
        }
        return Collections.emptySet();
    }

    public int getLastWeek() {
        return this.weekstate != null ? this.weekstate.getLast() : 0;
    }

    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    public WeekState getWeekstate() {
        return this.weekstate;
    }

    public void setWeekstate(WeekState weekstate) {
        this.weekstate = weekstate;
    }

    public int getWeeks() {
        if (this.weekstate == null) {
            return 0;
        }
        return this.weekstate.getWeeks();
    }

    public static float calcWeekHours(float period, int weeks) {
        float wh = period / (float)weeks;
        return Schedule.reserve(wh, 2);
    }

    private static float reserve(float num, int precision) {
        int mutilply = (int)Math.pow(10.0, precision + 1);
        if ((num *= (float)mutilply) % 10.0f >= 5.0f) {
            num += 10.0f;
        }
        num -= num % 10.0f;
        return num / (float)mutilply;
    }

    public float getWeekHours() {
        int w = this.getWeeks();
        if (w != 0) {
            return Schedule.calcWeekHours(this.period, w);
        }
        return 0.0f;
    }

    public int getFirstWeek() {
        return this.weekstate != null ? this.weekstate.getFirst() : 0;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public ClassroomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(ClassroomType roomType) {
        this.roomType = roomType;
    }

    public Status getStatus() {
        if (this.period == 0) {
            return Status.DONT_ARRANGE;
        }
        return this.getSessions().isEmpty() ? Status.NEED_ARRANGE : Status.ARRANGED;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("weekstate", (Object)this.weekstate).add("period", (Object)this.period).toString();
    }

    public static enum Status {
        NEED_ARRANGE("\u5f85\u5b89\u6392"),
        ARRANGED("\u5df2\u5b89\u6392"),
        DONT_ARRANGE("\u4e0d\u5b89\u6392");

        private String description;

        private Status(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

