/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.util;

import java.io.Serializable;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;

public class GenderRatio
implements Serializable,
Comparable<GenderRatio> {
    private static final long serialVersionUID = -8453864023951172823L;
    public static final GenderRatio empty = new GenderRatio(0);
    public final short value;

    public GenderRatio(short value) {
        this.value = value;
    }

    public boolean isAllMale() {
        return this.value == 256;
    }

    public boolean isAllFemale() {
        return this.value == 1;
    }

    public static GenderRatio of(String value) {
        if (value == null) {
            throw new RuntimeException("value cannot be null");
        }
        if (-1 == value.indexOf(58)) {
            throw new RuntimeException("value should contain ':'");
        }
        String[] pair = Strings.split((String)value, (char)':');
        if (!Numbers.isNumber((String)pair[0]) || !Numbers.isNumber((String)pair[1])) {
            throw new RuntimeException("bad format of ratio :" + value);
        }
        int res = (Numbers.toInt((String)pair[0]) << 8) + Numbers.toInt((String)pair[1]);
        return new GenderRatio((short)res);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    @Override
    public int compareTo(GenderRatio o) {
        return this.value - o.value;
    }

    public String toString() {
        if (this.value == 0) {
            return "";
        }
        return String.valueOf(this.value >> 8) + ":" + (this.value & 0xFF);
    }

    public boolean equals(Object arg0) {
        return ((GenderRatio)arg0).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

