/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.course.model.Restriction;
import org.openurp.edu.course.model.RestrictionMeta;

@Entity(name="org.openurp.edu.course.model.RestrictionItem")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class RestrictionItem
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6697398004696236934L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private RestrictionMeta meta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Restriction restriction;
    private boolean inclusive;
    @NotNull
    private String content;

    public RestrictionItem() {
    }

    public RestrictionItem(RestrictionMeta meta, String content, boolean inclusive) {
        this.meta = meta;
        this.content = content;
        this.inclusive = inclusive;
    }

    public RestrictionMeta getMeta() {
        return this.meta;
    }

    public void setMeta(RestrictionMeta meta) {
        this.meta = meta;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Restriction restriction) {
        this.restriction = restriction;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Object clone() {
        try {
            RestrictionItem clone = (RestrictionItem)super.clone();
            RestrictionMeta meta = new RestrictionMeta();
            meta.setId(this.getMeta().getId());
            clone.setMeta(meta);
            clone.setId(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getContentForHql() {
        if (null != this.content && null != this.meta && "GRADE".equals(this.meta.getName())) {
            this.content = "'" + this.content + "'";
        }
        return this.content;
    }

    public String toString() {
        return this.content;
    }
}

