/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.lang.Objects;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.base.code.model.CourseTakeType;
import org.openurp.edu.base.code.model.ElectionMode;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.course.model.Clazz;
import org.openurp.edu.course.model.Restriction;

@Entity(name="org.openurp.edu.course.model.CourseTaker")
public class CourseTaker
extends NumberIdTimeObject<Long>
implements Cloneable,
Comparable<CourseTaker> {
    private static final long serialVersionUID = -4305006607087691491L;
    @NaturalId(mutable=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseTakeType takeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ElectionMode electionMode;
    private boolean substitution = false;
    private boolean freeListening = false;
    private String remark;
    @ManyToOne(fetch=FetchType.LAZY)
    private Restriction restriction;

    public CourseTaker() {
        Date now;
        this.updatedAt = now = new Date();
    }

    public CourseTaker(Long takerId) {
        this();
        this.setId(takerId);
    }

    public CourseTaker(Clazz task, Student student, CourseTakeType courseTakeType) {
        this();
        this.clazz = task;
        this.semester = task.getSemester();
        this.course = task.getCourse();
        this.std = student;
        this.takeType = courseTakeType;
    }

    public Object clone() {
        try {
            CourseTaker taker = (CourseTaker)super.clone();
            taker.setId(null);
            taker.setClazz(null);
            return taker;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public CourseTakeType getTakeType() {
        return this.takeType;
    }

    public void setTakeType(CourseTakeType courseTakeType) {
        this.takeType = courseTakeType;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz task) {
        this.clazz = task;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CourseTaker)) {
            return false;
        }
        CourseTaker rhs = (CourseTaker)object;
        return Objects.equalsBuilder().add((Object)this.getClazz(), (Object)rhs.getClazz()).add((Object)this.getStd(), (Object)rhs.getStd()).isEquals();
    }

    public int hashCode() {
        return null != this.getStd() && null != this.getStd().getId() ? ((Long)this.getStd().getId()).hashCode() : 29;
    }

    @Override
    public int compareTo(CourseTaker other) {
        return Objects.compareBuilder().add((Object)this.std.getUser().getCode(), (Object)other.getStd().getUser().getCode()).toComparison();
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public ElectionMode getElectionMode() {
        return this.electionMode;
    }

    public void setElectionMode(ElectionMode electionMode) {
        this.electionMode = electionMode;
    }

    public boolean isFreeListening() {
        return this.freeListening;
    }

    public void setFreeListening(boolean freeListening) {
        this.freeListening = freeListening;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Restriction limitGroup) {
        this.restriction = limitGroup;
    }

    public boolean isSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(boolean substitution) {
        this.substitution = substitution;
    }
}

