/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Locale;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.security.Securities$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.code.model.CourseCategory;
import org.openurp.base.edu.code.model.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseProfile;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.service.SyllabusService;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.edu.helper.ProjectSupport;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DepartAction
implements EntityAction<Course>,
ProjectSupport {
    private Class entityType;
    private Logger logger;
    private EntityDao entityDao;
    private PropertyConfig config;
    private SyllabusService syllabusService;

    public DepartAction() {
        EntitySupport.$init$((EntitySupport)this);
        Logging.$init$((Logging)this);
        EntityAction.$init$((EntityAction)this);
        Statics.releaseFence();
    }

    public Class entityType() {
        return this.entityType;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityType_$eq(Class x$0) {
        this.entityType = x$0;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public PropertyConfig config() {
        return this.config;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void config_$eq(PropertyConfig x$1) {
        this.config = x$1;
    }

    public SyllabusService syllabusService() {
        return this.syllabusService;
    }

    public void syllabusService_$eq(SyllabusService x$1) {
        this.syllabusService = x$1;
    }

    public View index() {
        this.put("courseTypes", this.getCodes(CourseType.class));
        this.put("courseCategories", this.getCodes(CourseCategory.class));
        this.put("courseNatures", this.getCodes(CourseNature.class));
        this.put("teachingOffices", this.entityDao().getAll(TeachingOffice.class));
        this.put("departments", this.getDeparts());
        this.put("project", this.getProject());
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder<Course> query = this.getQueryBuilder();
        Seq courses = this.entityDao().search(query);
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("hasProfileCourses", statHelper.hasSyllabus((Iterable<Course>)courses));
        this.put("hasSyllabusCourses", statHelper.hasProfile((Iterable<Course>)courses));
        this.put("courses", courses);
        return this.forward(this.forward$default$1());
    }

    /*
     * WARNING - void declaration
     */
    public OqlBuilder<Course> getQueryBuilder() {
        void var1_1;
        OqlBuilder builder = EntityAction.getQueryBuilder$((EntityAction)this);
        builder.where("course.department in(:departs)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getDeparts()}));
        builder.where(this.simpleEntityName() + ".project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getProject()}));
        this.addTemporalOn(builder, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Option hasClazz = this.getBoolean("hasClazz");
        Option semesterId = this.getInt("semester.id");
        hasClazz.foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$1(builder, semesterId, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.getBoolean("hasProfile").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$2(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.getBoolean("hasSyllabus").foreach((Function1 & Serializable)x$1 -> DepartAction.getQueryBuilder$$anonfun$3(builder, BoxesRunTime.unboxToBoolean((Object)x$1)));
        return var1_1;
    }

    private <T extends Entity<?>> OqlBuilder<T> addTemporalOn(OqlBuilder<T> builder, Option<Object> active2) {
        active2.foreach((Function1 & Serializable)active -> DepartAction.addTemporalOn$$anonfun$1(builder, BoxesRunTime.unboxToBoolean((Object)active)));
        return builder;
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        CourseProfile courseProfile;
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Option<CourseProfile> option = this.getProfile(course);
        if (option instanceof Some) {
            CourseProfile p;
            courseProfile = p = (CourseProfile)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            CourseProfile cp = new CourseProfile();
            cp.course_$eq(course);
            courseProfile = cp;
        } else {
            throw new MatchError(option);
        }
        CourseProfile profile = courseProfile;
        this.put("profile", profile);
        this.put("course", course);
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        syllabusQuery.limit(1, 1);
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        this.put("Ems", Ems$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        CourseProfile profile = (CourseProfile)this.getProfile(course).getOrElse(DepartAction::$anonfun$1);
        Option user = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()}))).headOption();
        profile.course_$eq(course);
        this.populate((Entity)profile, "profile");
        profile.updatedAt_$eq(Instant.now());
        profile.updatedBy_$eq(user);
        this.entityDao().saveOrUpdate((Object)profile, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        Option authorId = this.getLong("syllabus.author.id");
        if (parts.size() > 0 && ((Part)parts.head()).getSize() > 0L && authorId.nonEmpty()) {
            Part part = (Part)parts.head();
            User author = (User)this.entityDao().get(User.class, authorId.get());
            Syllabus syllabus = this.syllabusService().upload(course, author, part.getInputStream(), Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), "."), Locale.SIMPLIFIED_CHINESE, Instant.now());
            syllabus.status_$eq(AuditStatus$.Published);
            this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        }
        return this.redirect("search", "info.save.success");
    }

    private Option<CourseProfile> getProfile(Course course) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        query.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    public View attachment() {
        SyllabusFile file = (SyllabusFile)this.entityDao().get(SyllabusFile.class, (Object)BoxesRunTime.boxToLong((long)this.longId("file")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(file.filePath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$1(OqlBuilder builder$1, Option semesterId$1, boolean x$1) {
        OqlBuilder oqlBuilder;
        boolean bl = x$1;
        if (bl) {
            Option option = semesterId$1;
            if (option instanceof Some) {
                int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                oqlBuilder = (OqlBuilder)builder$1.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course and clz.semester.id=:semesterId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sid)}));
                return oqlBuilder;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                oqlBuilder = (OqlBuilder)builder$1.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            return oqlBuilder;
        } else {
            if (bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            Option option = semesterId$1;
            if (option instanceof Some) {
                int sid = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                oqlBuilder = (OqlBuilder)builder$1.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course and clz.semester.id=:semesterId)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sid)}));
                return oqlBuilder;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                oqlBuilder = (OqlBuilder)builder$1.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        return oqlBuilder;
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$2(OqlBuilder builder$2, boolean x$1) {
        OqlBuilder oqlBuilder;
        boolean bl = x$1;
        if (bl) {
            oqlBuilder = (OqlBuilder)builder$2.where("exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else if (!bl) {
            oqlBuilder = (OqlBuilder)builder$2.where("not exists(from " + CourseProfile.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return oqlBuilder;
    }

    private static final /* synthetic */ OqlBuilder getQueryBuilder$$anonfun$3(OqlBuilder builder$3, boolean x$1) {
        OqlBuilder oqlBuilder;
        boolean bl = x$1;
        if (bl) {
            oqlBuilder = (OqlBuilder)builder$3.where("exists(from " + Syllabus.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else if (!bl) {
            oqlBuilder = (OqlBuilder)builder$3.where("not exists(from " + Syllabus.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return oqlBuilder;
    }

    private static final /* synthetic */ OqlBuilder addTemporalOn$$anonfun$1(OqlBuilder builder$4, boolean active) {
        return active ? (OqlBuilder)builder$4.where(builder$4.alias() + ".beginOn <= :now and (" + builder$4.alias() + ".endOn is null or " + builder$4.alias() + ".endOn >= :now)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()})) : (OqlBuilder)builder$4.where("not (" + builder$4.alias() + ".beginOn <= :now and (" + builder$4.alias() + ".endOn is null or " + builder$4.alias() + ".endOn >= :now))", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
    }

    private static final CourseProfile $anonfun$1() {
        return new CourseProfile();
    }
}

