/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action;

import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.EmsApp$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.Status$;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseProfile;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.web.helper.StatHelper;
import org.openurp.starter.edu.helper.ProjectSupport;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class InfoAction
implements ActionSupport,
EntityAction<Course>,
ProjectSupport {
    private Logger logger;
    private Class entityType;
    private EntityDao entityDao;
    private PropertyConfig config;

    public InfoAction() {
        Logging.$init$((Logging)this);
        EntitySupport.$init$((EntitySupport)this);
        EntityAction.$init$((EntityAction)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Class entityType() {
        return this.entityType;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityType_$eq(Class x$0) {
        this.entityType = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public PropertyConfig config() {
        return this.config;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void config_$eq(PropertyConfig x$1) {
        this.config = x$1;
    }

    public View index() {
        OqlBuilder dQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        dQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        dQuery.select("c.department.id,c.department.name,count(*)");
        dQuery.groupBy("c.department.id,c.department.code,c.department.name");
        dQuery.orderBy("c.department.code");
        this.put("departStat", this.entityDao().search((QueryBuilder)dQuery));
        OqlBuilder ctQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        ctQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        ctQuery.select("c.courseType.id,c.courseType.name,count(*)");
        ctQuery.groupBy("c.courseType.id,c.courseType.code,c.courseType.name");
        ctQuery.orderBy("c.courseType.code");
        this.put("typeStat", this.entityDao().search((QueryBuilder)ctQuery));
        OqlBuilder ccQuery = OqlBuilder$.MODULE$.from(Course.class.getName(), "c");
        ccQuery.where("c.endOn is null or c.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        ccQuery.select("c.nature.id,c.nature.name,count(*)");
        ccQuery.groupBy("c.nature.id,c.nature.code,c.nature.name");
        ccQuery.orderBy("c.nature.code");
        this.put("natureStat", this.entityDao().search((QueryBuilder)ccQuery));
        return this.forward(this.forward$default$1());
    }

    public View search() {
        OqlBuilder query = this.getQueryBuilder();
        this.get("q").foreach((Function1 & Serializable)q -> (OqlBuilder)query.where("course.code like :q or course.name like :q", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + q.trim() + "%"})));
        query.where("course.endOn is null or course.endOn > :now", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{LocalDate.now()}));
        query.orderBy("course.code");
        this.getBoolean("hasClazz").foreach((Function1 & Serializable)x$1 -> InfoAction.search$$anonfun$2(query, BoxesRunTime.unboxToBoolean((Object)x$1)));
        this.put("courses", this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Course course = (Course)this.getModel(this.entityName(), this.convertId(id));
        this.put(this.simpleEntityName(), course);
        OqlBuilder profileQuery = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        profileQuery.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        this.put("profile", this.entityDao().search((QueryBuilder)profileQuery).headOption());
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.where("s.status=:publishsed", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{AuditStatus$.Published}));
        syllabusQuery.orderBy("s.updatedAt desc");
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("clazzInfos", statHelper.statClazzInfo(course));
        this.put("planCourseInfos", statHelper.statPlanCourseInfo(course));
        return this.forward(this.forward$default$1());
    }

    public View attachment() {
        View view;
        SyllabusFile file = (SyllabusFile)this.entityDao().get(SyllabusFile.class, (Object)BoxesRunTime.boxToLong((long)this.longId("file")));
        AuditStatus auditStatus = file.syllabus().status();
        AuditStatus auditStatus2 = AuditStatus$.Published;
        if (!(auditStatus != null ? !auditStatus.equals(auditStatus2) : auditStatus2 != null)) {
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(file.filePath());
            this.response().sendRedirect(((URL)path.get()).toString());
            view = null;
        } else {
            view = Status$.MODULE$.NotFound();
        }
        return view;
    }

    private static final /* synthetic */ OqlBuilder search$$anonfun$2(OqlBuilder query$2, boolean x$1) {
        OqlBuilder oqlBuilder;
        boolean bl = x$1;
        if (bl) {
            oqlBuilder = (OqlBuilder)query$2.where("exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else if (!bl) {
            oqlBuilder = (OqlBuilder)query$2.where("not exists(from " + Clazz.class.getName() + " clz where clz.course=course)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return oqlBuilder;
    }
}

