/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.web.action;

import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.net.http.HttpUtils$;
import org.beangle.commons.net.http.ResourceStatus;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.security.Securities$;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.support.ServletSupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.support.action.EntityAction;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.User;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.CourseProfile;
import org.openurp.edu.course.model.Syllabus;
import org.openurp.edu.course.model.SyllabusFile;
import org.openurp.edu.course.service.SyllabusService;
import org.openurp.edu.course.web.helper.StatHelper;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ReviseAction
implements EntityAction<CourseProfile>,
ServletSupport {
    private Class entityType;
    private Logger logger;
    private EntityDao entityDao;
    private PropertyConfig config;
    private SyllabusService syllabusService;

    public ReviseAction() {
        EntitySupport.$init$((EntitySupport)this);
        Logging.$init$((Logging)this);
        EntityAction.$init$((EntityAction)this);
        Statics.releaseFence();
    }

    public Class entityType() {
        return this.entityType;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityType_$eq(Class x$0) {
        this.entityType = x$0;
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public PropertyConfig config() {
        return this.config;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public void config_$eq(PropertyConfig x$1) {
        this.config = x$1;
    }

    public SyllabusService syllabusService() {
        return this.syllabusService;
    }

    public void syllabusService_$eq(SyllabusService x$1) {
        this.syllabusService = x$1;
    }

    public View index() {
        LocalDate today = LocalDate.now();
        OqlBuilder query = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "c");
        query.join("c.teachers", "t");
        query.where("c.semester.endOn > :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{today}));
        query.where("t.user.code=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        query.select("distinct c.course");
        query.orderBy("c.course.code");
        Seq activeCourses = this.entityDao().search((QueryBuilder)query);
        OqlBuilder query2 = OqlBuilder$.MODULE$.from(Clazz.class.getName(), "c");
        query2.join("c.teachers", "t");
        query2.where("c.semester.endOn <= :today", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{today}));
        query2.where("t.user.code=:me", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        query2.select("distinct c.course");
        query2.orderBy("c.course.code");
        Buffer hisCourses = Collections$.MODULE$.newBuffer((Iterable)this.entityDao().search((QueryBuilder)query2));
        hisCourses.subtractAll((IterableOnce)activeCourses);
        StatHelper statHelper = new StatHelper(this.entityDao());
        Seq courses = (Seq)activeCourses.$plus$plus((IterableOnce)hisCourses);
        this.put("hasProfileCourses", statHelper.hasSyllabus((Iterable<Course>)courses));
        this.put("hasSyllabusCourses", statHelper.hasProfile((Iterable<Course>)courses));
        this.put("activeCourses", activeCourses);
        this.put("hisCourses", hisCourses);
        this.put("courses", courses);
        this.put("zh_template_url", this.getTemplateFile("zh.docx"));
        this.put("en_template_url", this.getTemplateFile("en.docx"));
        return this.forward(this.forward$default$1());
    }

    public Option<URL> getTemplateFile(String name) {
        URL url = new URL(Ems$.MODULE$.api() + "/platform/config/files/" + EmsApp$.MODULE$.name() + "/syllabus/template/" + name);
        ResourceStatus status = HttpUtils$.MODULE$.access(url);
        return status.isOk() ? Some$.MODULE$.apply((Object)url) : None$.MODULE$;
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("profile", this.getProfile(course));
        this.put("course", course);
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        StatHelper statHelper = new StatHelper(this.entityDao());
        this.put("clazzInfos", statHelper.statClazzInfo(course));
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        CourseProfile courseProfile;
        Course course = (Course)this.entityDao().get(Course.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        Option<CourseProfile> option = this.getProfile(course);
        if (option instanceof Some) {
            CourseProfile p;
            courseProfile = p = (CourseProfile)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            CourseProfile cp = new CourseProfile();
            cp.course_$eq(course);
            courseProfile = cp;
        } else {
            throw new MatchError(option);
        }
        CourseProfile profile = courseProfile;
        this.put("profile", profile);
        this.put("course", course);
        OqlBuilder syllabusQuery = OqlBuilder$.MODULE$.from(Syllabus.class, "s");
        syllabusQuery.where("s.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        syllabusQuery.orderBy("s.semester.beginOn desc");
        syllabusQuery.limit(1, 1);
        Option author = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()}))).headOption();
        this.put("author", author);
        this.put("syllabuses", this.entityDao().search((QueryBuilder)syllabusQuery));
        this.put("Ems", Ems$.MODULE$);
        return this.forward(this.forward$default$1());
    }

    private Option<CourseProfile> getProfile(Course course) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseProfile.class, "cp");
        query.where("cp.course = :course", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{course}));
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        CourseProfile entity = (CourseProfile)this.populate(this.getModel((Serializable)((Object)id)), this.entityName(), this.simpleEntityName());
        return this.persist(entity);
    }

    public String simpleEntityName() {
        return "profile";
    }

    public View persist(CourseProfile profile) {
        profile.updatedAt_$eq(Instant.now());
        Option user = this.entityDao().findBy(User.class, "code", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Securities$.MODULE$.user()}))).headOption();
        profile.updatedBy_$eq(user);
        this.entityDao().saveOrUpdate((Object)profile, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CourseProfile[0]));
        Course course = (Course)this.entityDao().get(Course.class, profile.course().id());
        Iterable parts = this.getAll("attachment", Part.class, ClassTag$.MODULE$.apply(Part.class));
        Option authorId = this.getLong("syllabus.author.id");
        if (parts.size() > 0 && ((Part)parts.head()).getSize() > 0L && authorId.nonEmpty()) {
            Part part = (Part)parts.head();
            User author = (User)this.entityDao().get(User.class, authorId.get());
            Syllabus syllabus = this.syllabusService().upload(course, author, part.getInputStream(), Strings$.MODULE$.substringAfterLast(part.getSubmittedFileName(), "."), Locale.SIMPLIFIED_CHINESE, Instant.now());
            syllabus.status_$eq(AuditStatus$.Published);
            this.entityDao().saveOrUpdate((Object)syllabus, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Syllabus[0]));
        }
        return this.redirect("index", "id=" + profile.course().id(), "info.save.success");
    }

    @mapping(method="post")
    public View save() {
        return this.persist((CourseProfile)this.populateEntity());
    }

    public View attachment() {
        SyllabusFile file = (SyllabusFile)this.entityDao().get(SyllabusFile.class, (Object)BoxesRunTime.boxToLong((long)this.longId("file")));
        Option path = EmsApp$.MODULE$.getBlobRepository(true).url(file.filePath());
        this.response().sendRedirect(((URL)path.get()).toString());
        return null;
    }
}

